/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.PathUtils;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.javac.CompilationCanceledException;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.TransformableJavaFileObject;

class JavacFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager>
implements StandardJavaFileManager {
    private final Context myContext;
    private final Collection<JavaSourceTransformer> mySourceTransformers;
    private Map<File, Set<File>> myOutputsMap = Collections.emptyMap();
    @Nullable
    private String myEncodingName;
    private int myChecksCounter = 0;
    private static Map<Method, Boolean> ourImplStatus = Collections.synchronizedMap(new HashMap());

    public JavacFileManager(Context context, Collection<JavaSourceTransformer> transformers) {
        super(context.getStandardFileManager());
        this.myContext = context;
        this.mySourceTransformers = transformers;
    }

    public void setOutputDirectories(Map<File, Set<File>> outputDirToSrcRoots) throws IOException {
        for (File outputDir : outputDirToSrcRoots.keySet()) {
            this.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputDir));
        }
        this.myOutputsMap = outputDirToSrcRoots;
    }

    @Override
    public boolean handleOption(String current, final Iterator<String> remaining) {
        if ("-encoding".equalsIgnoreCase(current) && remaining.hasNext()) {
            String encoding;
            this.myEncodingName = encoding = remaining.next();
            return super.handleOption(current, new Iterator<String>(){
                private boolean encodingConsumed = false;

                @Override
                public boolean hasNext() {
                    return !this.encodingConsumed || remaining.hasNext();
                }

                @Override
                public String next() {
                    if (!this.encodingConsumed) {
                        this.encodingConsumed = true;
                        return encoding;
                    }
                    return (String)remaining.next();
                }

                @Override
                public void remove() {
                    if (this.encodingConsumed) {
                        remaining.remove();
                    }
                }
            });
        }
        return super.handleOption(current, remaining);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return super.inferBinaryName(location, JavacFileManager.unwrapFileObject(file));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        this.getStdManager().setLocation(location, path);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return this.wrapJavaFileObjects(this.getStdManager().getJavaFileObjectsFromFiles(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.wrapJavaFileObjects(this.getStdManager().getJavaFileObjects(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return this.wrapJavaFileObjects(this.getStdManager().getJavaFileObjectsFromStrings(names));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.wrapJavaFileObjects(this.getStdManager().getJavaFileObjects(names));
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return this.getStdManager().getLocation(location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (a instanceof OutputFileObject || b instanceof OutputFileObject) {
            return a.equals(b);
        }
        return super.isSameFile(JavacFileManager.unwrapFileObject(a), JavacFileManager.unwrapFileObject(b));
    }

    private static FileObject unwrapFileObject(FileObject a) {
        return a instanceof TransformableJavaFileObject ? ((TransformableJavaFileObject)a).getOriginal() : a;
    }

    private static JavaFileObject unwrapFileObject(JavaFileObject a) {
        return a instanceof TransformableJavaFileObject ? ((TransformableJavaFileObject)a).getOriginal() : a;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        this.checkCanceled();
        FileObject fo = super.getFileForInput(location, packageName, relativeName);
        if (fo == null) {
            throw new FileNotFoundException("Resource does not exist : " + location + '/' + packageName + '/' + relativeName);
        }
        return fo;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> objects = super.list(location, packageName, kinds, recurse);
        return kinds.contains((Object)JavaFileObject.Kind.SOURCE) ? this.wrapJavaFileObjects(objects) : objects;
    }

    private Iterable<? extends JavaFileObject> wrapJavaFileObjects(Iterable<? extends JavaFileObject> originalObjects) {
        if (this.mySourceTransformers.isEmpty()) {
            return originalObjects;
        }
        Iterable<? extends JavaFileObject> wrapped = null;
        for (JavaFileObject javaFileObject : originalObjects) {
            if (wrapped == null) {
                wrapped = new ArrayList<JavaFileObject>();
            }
            wrapped.add((JavaFileObject)(JavaFileObject.Kind.SOURCE.equals((Object)javaFileObject.getKind()) ? new TransformableJavaFileObject(javaFileObject, this.mySourceTransformers) : javaFileObject));
        }
        return wrapped != null ? wrapped : originalObjects;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        this.checkCanceled();
        JavaFileObject fo = super.getJavaFileForInput(location, className, kind);
        if (fo == null && !"module-info".equals(className)) {
            throw new FileNotFoundException("Java resource does not exist : " + location + '/' + (Object)((Object)kind) + '/' + className);
        }
        return this.mySourceTransformers.isEmpty() ? fo : new TransformableJavaFileObject(fo, this.mySourceTransformers);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind != JavaFileObject.Kind.SOURCE && kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, kind, JavacFileManager.externalizeFileName(className, kind), className, sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        StringBuilder name = new StringBuilder();
        if (packageName.isEmpty()) {
            name.append(relativeName);
        } else {
            name.append(JavacFileManager.externalizeFileName(packageName)).append(File.separatorChar).append(relativeName);
        }
        String fileName = name.toString();
        return this.getFileForOutput(location, JavacFileManager.getKind(fileName), fileName, null, sibling);
    }

    private OutputFileObject getFileForOutput(JavaFileManager.Location location, JavaFileObject.Kind kind, String fileName, @Nullable String className, FileObject sibling) throws IOException {
        JavaFileObject javaFileObject;
        this.checkCanceled();
        JavaFileObject src = null;
        if (sibling instanceof JavaFileObject && (javaFileObject = (JavaFileObject)sibling).getKind() == JavaFileObject.Kind.SOURCE) {
            src = javaFileObject;
        }
        File dir = this.getSingleOutputDirectory(location, src);
        if (location == StandardLocation.CLASS_OUTPUT) {
            if (dir == null) {
                throw new IOException("Output directory is not specified");
            }
        } else if (location == StandardLocation.SOURCE_OUTPUT && dir == null && (dir = this.getSingleOutputDirectory(StandardLocation.CLASS_OUTPUT, src)) == null) {
            throw new IOException("Neither class output directory nor source output are specified");
        }
        File file = dir == null ? new File(fileName).getAbsoluteFile() : new File(dir, fileName);
        return new OutputFileObject(this.myContext, dir, fileName, file, kind, className, src != null ? src.toUri() : null, this.myEncodingName);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : path) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), this.myContext.getStandardFileManager().getClass().getClassLoader());
    }

    private File getSingleOutputDirectory(JavaFileManager.Location loc, JavaFileObject sourceFile) {
        Iterator<? extends File> it;
        File outputDir;
        if (loc == StandardLocation.CLASS_OUTPUT && this.myOutputsMap.size() > 1 && sourceFile != null && (outputDir = this.findOutputDir(PathUtils.convertToFile(sourceFile.toUri()))) != null) {
            return outputDir;
        }
        Iterable<? extends File> location = this.getStdManager().getLocation(loc);
        if (location != null && (it = location.iterator()).hasNext()) {
            return it.next();
        }
        return null;
    }

    private File findOutputDir(File src) {
        File file = FileUtilRt.getParentFile((File)src);
        while (file != null) {
            for (Map.Entry<File, Set<File>> entry : this.myOutputsMap.entrySet()) {
                if (!entry.getValue().contains(file)) continue;
                return entry.getKey();
            }
            file = FileUtilRt.getParentFile((File)file);
        }
        return null;
    }

    @NotNull
    private StandardJavaFileManager getStdManager() {
        StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        if (standardJavaFileManager == null) {
            JavacFileManager.$$$reportNull$$$0(0);
        }
        return standardJavaFileManager;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myOutputsMap = Collections.emptyMap();
        }
    }

    private static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static String externalizeFileName(CharSequence cs, JavaFileObject.Kind kind) {
        return JavacFileManager.externalizeFileName(cs) + kind.extension;
    }

    private static String externalizeFileName(CharSequence name) {
        return name.toString().replace('.', File.separatorChar);
    }

    private void checkCanceled() {
        int counter;
        this.myChecksCounter = counter = (this.myChecksCounter + 1) % 10;
        if (counter == 0 && this.myContext.isCanceled()) {
            throw new CompilationCanceledException();
        }
    }

    public Context getContext() {
        return this.myContext;
    }

    JavaFileManager getApiCallHandler(Method method) {
        Boolean isImplemented = ourImplStatus.get(method);
        if (isImplemented == null) {
            try {
                JavacFileManager.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
                isImplemented = Boolean.TRUE;
            }
            catch (NoSuchMethodException e) {
                isImplemented = Boolean.FALSE;
            }
            ourImplStatus.put(method, isImplemented);
        }
        return isImplemented != false ? this : this.getStdManager();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/JavacFileManager", "getStdManager"));
    }

    static interface Context {
        public boolean isCanceled();

        public StandardJavaFileManager getStandardFileManager();

        public void consumeOutputFile(@NotNull OutputFileObject var1);

        public void reportMessage(Diagnostic.Kind var1, String var2);
    }
}

