/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.storage;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class BuildTargetStorages
extends CompositeStorageOwner {
    private final BuildTarget<?> myTarget;
    private final BuildDataPaths myPaths;
    private final ConcurrentMap<StorageProvider<?>, AtomicNotNullLazyValue<? extends StorageOwner>> myStorages = new ConcurrentHashMap(16, 0.75f, 1);

    public BuildTargetStorages(BuildTarget<?> target, BuildDataPaths paths) {
        this.myTarget = target;
        this.myPaths = paths;
    }

    @NotNull
    public <S extends StorageOwner> S getOrCreateStorage(final @NotNull StorageProvider<S> provider) throws IOException {
        StorageOwner storageOwner;
        AtomicNotNullLazyValue newValue;
        Object lazyValue;
        if (provider == null) {
            BuildTargetStorages.$$$reportNull$$$0(0);
        }
        if ((lazyValue = (NotNullLazyValue)this.myStorages.get(provider)) == null && (lazyValue = (NotNullLazyValue)this.myStorages.putIfAbsent(provider, (AtomicNotNullLazyValue<? extends StorageOwner>)(newValue = new AtomicNotNullLazyValue<S>(){

            @NotNull
            protected S compute() {
                Object s;
                try {
                    s = provider.createStorage(BuildTargetStorages.this.myPaths.getTargetDataRoot(BuildTargetStorages.this.myTarget));
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                if (s == null) {
                    1.$$$reportNull$$$0(0);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/storage/BuildTargetStorages$1", "compute"));
            }
        }))) == null) {
            lazyValue = newValue;
        }
        try {
            storageOwner = (StorageOwner)lazyValue.getValue();
        }
        catch (BuildDataCorruptedException e) {
            throw e.getCause();
        }
        if (storageOwner == null) {
            BuildTargetStorages.$$$reportNull$$$0(1);
        }
        return (S)storageOwner;
    }

    @Override
    protected Iterable<? extends StorageOwner> getChildStorages() {
        return new Iterable<StorageOwner>(){

            @Override
            public Iterator<StorageOwner> iterator() {
                final Iterator iterator = BuildTargetStorages.this.myStorages.values().iterator();
                return new Iterator<StorageOwner>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public StorageOwner next() {
                        return (StorageOwner)((AtomicNotNullLazyValue)iterator.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/impl/storage/BuildTargetStorages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/impl/storage/BuildTargetStorages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateStorage";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

