/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class VersionRange
implements Comparable<VersionRange> {
    final Version high;
    final Version low;
    char start = (char)91;
    char end = (char)93;
    static String V = "[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[a-zA-Z0-9_-]+)?)?)?";
    static Pattern RANGE = Pattern.compile("(\\(|\\[)\\s*(" + V + ")\\s*,\\s*(" + V + ")\\s*(\\)|\\])");

    public VersionRange(boolean lowInclusive, Version low, Version high, boolean highInclusive) {
        if (low.compareTo(high) > 0) {
            throw new IllegalArgumentException("Low Range is higher than High Range: " + low + "-" + high);
        }
        this.low = low;
        this.high = high;
        this.start = (char)(lowInclusive ? 91 : 40);
        this.end = (char)(highInclusive ? 93 : 41);
    }

    public VersionRange(String string) {
        string = string.trim();
        Matcher m = RANGE.matcher(string);
        if (m.matches()) {
            this.start = m.group(1).charAt(0);
            this.low = new Version(m.group(2));
            this.high = new Version(m.group(6));
            this.end = m.group(10).charAt(0);
            if (this.low.compareTo(this.high) > 0) {
                throw new IllegalArgumentException("Low Range is higher than High Range: " + this.low + "-" + this.high);
            }
        } else {
            this.start = (char)91;
            this.high = this.low = new Version(string);
            this.end = (char)93;
        }
    }

    public boolean isRange() {
        return this.high != this.low;
    }

    public boolean includeLow() {
        return this.start == '[';
    }

    public boolean includeHigh() {
        return this.end == ']';
    }

    public String toString() {
        if (this.high == this.low) {
            return this.high.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.start);
        sb.append(this.low);
        sb.append(',');
        sb.append(this.high);
        sb.append(this.end);
        return sb.toString();
    }

    public boolean equals(VersionRange other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.low.hashCode() * this.high.hashCode();
    }

    @Override
    public int compareTo(VersionRange range) {
        VersionRange a = this;
        VersionRange b = range;
        if (range.isRange()) {
            a = range;
            b = this;
        } else if (!this.isRange()) {
            return this.low.compareTo(range.high);
        }
        int l = a.low.compareTo(b.low);
        boolean ll = false;
        if (a.includeLow()) {
            ll = l <= 0;
        } else {
            boolean bl = ll = l < 0;
        }
        if (!ll) {
            return -1;
        }
        int h = a.high.compareTo(b.high);
        if (a.includeHigh()) {
            ll = h >= 0;
        } else {
            boolean bl = ll = h > 0;
        }
        if (ll) {
            return 0;
        }
        return 1;
    }

    public Version getHigh() {
        return this.high;
    }

    public Version getLow() {
        return this.low;
    }

    public boolean match(Version version) {
        int lowmatch = version.compareTo(this.low);
        if (lowmatch < 0) {
            return false;
        }
        if (lowmatch == 0 && !this.includeLow()) {
            return false;
        }
        int highmatch = version.compareTo(this.high);
        if (highmatch > 0) {
            return false;
        }
        return highmatch != 0 || this.includeHigh();
    }
}

