/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.lib.io.IO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ResolverLogger
implements LogService {
    public static final int DEFAULT_LEVEL = 4;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private final File file;
    private final PrintWriter printer;
    private int level;
    private String log;

    public ResolverLogger() {
        this(4);
    }

    public ResolverLogger(int level) {
        try {
            this.level = level;
            this.file = File.createTempFile("tmp", ".log");
            this.file.deleteOnExit();
            this.printer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolverLogger(int level, PrintStream out) {
        this.level = level;
        this.file = null;
        this.printer = new PrintWriter(out);
    }

    @Override
    public void log(int level, String msg, Throwable throwable) {
        String s = "";
        s = s + msg;
        if (throwable != null) {
            s = s + " (" + throwable + ")";
        }
        switch (level) {
            case 4: {
                this.printer.println("DEBUG: " + s);
                break;
            }
            case 1: {
                this.printer.println("ERROR: " + s);
                if (throwable == null) break;
                throwable.printStackTrace(this.printer);
                break;
            }
            case 3: {
                this.printer.println("INFO: " + s);
                break;
            }
            case 2: {
                this.printer.println("WARNING: " + s);
                break;
            }
            default: {
                this.printer.println("UNKNOWN[" + level + "]: " + s);
            }
        }
        this.printer.flush();
        this.log = null;
    }

    public String getLog() {
        if (this.log == null) {
            try {
                this.printer.flush();
                if (this.file.length() <= 8001L) {
                    this.log = IO.collect(this.file);
                } else {
                    StringBuilder sb = new StringBuilder(10000);
                    sb.append("Log too large. Split from ").append(this.file.getAbsolutePath()).append("\nsize ").append((this.file.length() + 512L) / 1024L).append(" Kb\n===================\n");
                    byte[] buffer = new byte[4000];
                    RandomAccessFile raf = new RandomAccessFile(this.file, "r");
                    raf.readFully(buffer);
                    sb.append(new String(buffer, "UTF-8"));
                    sb.append("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n");
                    raf.seek(raf.length() - (long)buffer.length);
                    raf.readFully(buffer);
                    String s = new String(buffer, "UTF-8");
                    sb.append(s);
                    raf.close();
                    this.log = sb.toString();
                }
            }
            catch (Exception e) {
                this.log = e.getMessage();
            }
        }
        return this.log;
    }

    public void finalize() {
        this.file.delete();
    }

    public int getLogLevel() {
        return this.level;
    }

    @Override
    public void log(int level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(ServiceReference sr, int level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(level, message, exception);
    }
}

