/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.DirectoryHandler;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.ProviderHandler;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\tH\u0004J\u0018\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0017J\b\u0010+\u001a\u0004\u0018\u00010\u0018J\u0010\u0010,\u001a\u0004\u0018\u00010\u00182\u0006\u0010-\u001a\u00020\u0017J\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020&H\u0002J\u0016\u00101\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00182\u0006\u00102\u001a\u000203J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010)\u001a\u00020\u00182\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020&H\u0014J\b\u00107\u001a\u00020&H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u00104\u001a\u000205H\u0002J\u001e\u00108\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00182\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0018\u00109\u001a\u0004\u0018\u00010\u00052\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050;H\u0002J\u0018\u0010<\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u0010=\u001a\u00020>H\u0003R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R \u0010\u001b\u001a\u0004\u0018\u00010\t8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000b\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006@"}, d2={"Lcom/android/ide/common/fonts/FontLoader;", "", "()V", "fontFamilies", "", "Lcom/android/ide/common/fonts/FontFamily;", "getFontFamilies", "()Ljava/util/List;", "fontPath", "Ljava/io/File;", "getFontPath", "()Ljava/io/File;", "fonts", "Ljava/util/HashMap;", "getFonts", "()Ljava/util/HashMap;", "setFonts", "(Ljava/util/HashMap;)V", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "providers", "", "Lcom/android/ide/common/fonts/FontProvider;", "getProviders", "setProviders", "sdkHome", "getSdkHome", "setSdkHome", "(Ljava/io/File;)V", "sortedFontFamilies", "Ljava/util/ArrayList;", "getSortedFontFamilies", "()Ljava/util/ArrayList;", "setSortedFontFamilies", "(Ljava/util/ArrayList;)V", "clear", "", "newSdkHome", "findFont", "provider", "fontName", "findOnlyKnownProvider", "findProvider", "authority", "fontsLoaded", "", "lazyLoad", "loadDirectory", "url", "Ljava/net/URL;", "source", "Lorg/xml/sax/InputSource;", "loadFonts", "loadProviders", "mergeFonts", "next", "iterator", "", "parseXml", "handler", "Lorg/xml/sax/helpers/DefaultHandler;", "Companion", "android.sdktools.sdk-common"})
public class FontLoader {
    @NotNull
    private final Object lock = new Object();
    @Nullable
    private File sdkHome;
    @NotNull
    private HashMap<String, FontProvider> providers = new HashMap();
    @NotNull
    private HashMap<FontFamily, FontFamily> fonts = new HashMap();
    @NotNull
    private ArrayList<FontFamily> sortedFontFamilies = new ArrayList();
    @JvmField
    @Nullable
    protected static FontLoader instance;
    public static final Companion Companion;

    @NotNull
    protected final Object getLock() {
        return this.lock;
    }

    @Nullable
    protected final File getSdkHome() {
        return this.sdkHome;
    }

    protected final void setSdkHome(@Nullable File file) {
        this.sdkHome = file;
    }

    @NotNull
    protected final HashMap<String, FontProvider> getProviders() {
        return this.providers;
    }

    protected final void setProviders(@NotNull HashMap<String, FontProvider> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.providers = hashMap;
    }

    @NotNull
    protected final HashMap<FontFamily, FontFamily> getFonts() {
        return this.fonts;
    }

    protected final void setFonts(@NotNull HashMap<FontFamily, FontFamily> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.fonts = hashMap;
    }

    @NotNull
    protected final ArrayList<FontFamily> getSortedFontFamilies() {
        return this.sortedFontFamilies;
    }

    protected final void setSortedFontFamilies(@NotNull ArrayList<FontFamily> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.sortedFontFamilies = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File getFontPath() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.sdkHome != null) break block4;
                File file = null;
                return file;
            }
            File file = new File(this.sdkHome, "fonts");
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<FontFamily> getFontFamilies() {
        Object object = this.lock;
        synchronized (object) {
            this.lazyLoad();
            List list = new ArrayList(this.sortedFontFamilies);
            return list;
        }
    }

    public final void loadDirectory(@NotNull FontProvider provider, @NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        List<FontFamily> loadedFonts = this.loadDirectory(provider, new InputSource(url.toString()));
        this.mergeFonts(provider, loadedFonts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final FontProvider findProvider(@NotNull String authority) {
        Intrinsics.checkParameterIsNotNull((Object)authority, (String)"authority");
        Object object = this.lock;
        synchronized (object) {
            this.lazyLoad();
            FontProvider fontProvider = this.providers.get(authority);
            return fontProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final FontProvider findOnlyKnownProvider() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                this.lazyLoad();
                if (this.providers.size() == 1) break block4;
                FontProvider fontProvider = null;
                return fontProvider;
            }
            Collection<FontProvider> collection = this.providers.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"providers.values");
            FontProvider fontProvider = (FontProvider)CollectionsKt.first((Iterable)collection);
            return fontProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean fontsLoaded() {
        Object object = this.lock;
        synchronized (object) {
            this.lazyLoad();
            Map map = this.fonts;
            boolean bl = !map.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final FontFamily findFont(@NotNull FontProvider provider, @NotNull String fontName) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)fontName, (String)"fontName");
        Object object = this.lock;
        synchronized (object) {
            this.lazyLoad();
            FontFamily fontFamily = this.fonts.get(new FontFamily(provider, fontName));
            return fontFamily;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clear(@Nullable File newSdkHome) {
        Object object = this.lock;
        synchronized (object) {
            if (Intrinsics.areEqual((Object)this.sdkHome, (Object)newSdkHome) ^ true) {
                this.sdkHome = newSdkHome;
                this.providers.clear();
                this.fonts.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lazyLoad() {
        Object object = this.lock;
        synchronized (object) {
            Map map = this.providers;
            if (!map.isEmpty()) {
                return;
            }
            this.loadProviders();
            this.loadFonts();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void loadProviders() {
        File fontFolder;
        File providerFolder;
        File providerFile;
        File localSdkHome = this.sdkHome;
        if (localSdkHome != null && localSdkHome.exists() && (providerFile = new File(providerFolder = new File(fontFolder = new File(localSdkHome, "fonts"), "providers"), "provider_directory.xml")).exists()) {
            List<FontProvider> providerList = this.loadProviders(new InputSource(new FileReader(providerFile)));
            for (FontProvider provider : providerList) {
                Map map = this.providers;
                String string = provider.getAuthority();
                FontProvider fontProvider = provider;
                map.put(string, fontProvider);
            }
        }
        if (this.providers.isEmpty()) {
            Map map = this.providers;
            String string = "com.google.android.gms.fonts";
            FontProvider fontProvider = FontProvider.GOOGLE_PROVIDER;
            map.put(string, fontProvider);
        }
    }

    protected void loadFonts() {
        File file = this.sdkHome;
        if (file == null) {
            return;
        }
        File localSdkHome = file;
        File fontFolder = new File(localSdkHome, "fonts");
        for (FontProvider provider : this.providers.values()) {
            File providerFolder = new File(fontFolder, provider.getAuthority());
            File directoryFolder = new File(providerFolder, "directory");
            File directoryFile = new File(directoryFolder, "font_directory.xml");
            if (!directoryFile.exists()) continue;
            FontProvider fontProvider = provider;
            Intrinsics.checkExpressionValueIsNotNull((Object)fontProvider, (String)"provider");
            List<FontFamily> families = this.loadDirectory(fontProvider, new InputSource(new FileReader(directoryFile)));
            for (FontFamily family : families) {
                Map map = this.fonts;
                FontFamily fontFamily = family;
                map.put(family, fontFamily);
            }
            this.sortedFontFamilies.addAll((Collection<FontFamily>)families);
        }
        CollectionsKt.sort((List)this.sortedFontFamilies);
    }

    private final List<FontProvider> loadProviders(InputSource source) {
        ProviderHandler handler = new ProviderHandler();
        this.parseXml(source, handler);
        return handler.getFontProviders();
    }

    private final List<FontFamily> loadDirectory(FontProvider provider, InputSource source) {
        DirectoryHandler handler = new DirectoryHandler(provider);
        this.parseXml(source, handler);
        return handler.getFontFamilies();
    }

    private final void parseXml(InputSource source, DefaultHandler handler) throws SAXException, ParserConfigurationException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)factory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)factory);
            parser.parse(source, handler);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeFonts(FontProvider provider, List<FontFamily> fontFamilies) {
        Object object = this.lock;
        synchronized (object) {
            FontFamily fontFamily;
            Map map;
            ArrayList existingFonts = new ArrayList(this.sortedFontFamilies);
            this.sortedFontFamilies.clear();
            Collections.sort(fontFamilies);
            Iterator<FontFamily> existing = existingFonts.iterator();
            Iterator<FontFamily> loaded = fontFamilies.iterator();
            Iterator<FontFamily> iterator = existing;
            Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"existing");
            FontFamily existingFont = this.next(iterator);
            FontFamily loadedFont = this.next(loaded);
            block7: while (existingFont != null && loadedFont != null) {
                switch (existingFont.compareTo(loadedFont)) {
                    case 1: {
                        this.sortedFontFamilies.add(loadedFont);
                        map = this.fonts;
                        fontFamily = loadedFont;
                        map.put(loadedFont, fontFamily);
                        loadedFont = this.next(loaded);
                        continue block7;
                    }
                    case -1: {
                        if (Intrinsics.areEqual((Object)provider, (Object)existingFont.getProvider())) {
                            this.fonts.remove(existingFont);
                        } else {
                            this.sortedFontFamilies.add(existingFont);
                        }
                        existingFont = this.next(existing);
                        continue block7;
                    }
                }
                this.sortedFontFamilies.add(loadedFont);
                map = this.fonts;
                fontFamily = loadedFont;
                map.put(loadedFont, fontFamily);
                existingFont = this.next(existing);
                loadedFont = this.next(loaded);
            }
            while (existingFont != null) {
                if (Intrinsics.areEqual((Object)provider, (Object)existingFont.getProvider())) {
                    this.fonts.remove(existingFont);
                } else {
                    this.sortedFontFamilies.add(existingFont);
                }
                existingFont = this.next(existing);
            }
            while (loadedFont != null) {
                this.sortedFontFamilies.add(loadedFont);
                map = this.fonts;
                fontFamily = loadedFont;
                map.put(loadedFont, fontFamily);
                loadedFont = this.next(loaded);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final FontFamily next(Iterator<FontFamily> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @NotNull
    public static final FontLoader getInstance(@Nullable File sdkHome) {
        return Companion.getInstance(sdkHome);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/ide/common/fonts/FontLoader$Companion;", "", "()V", "instance", "Lcom/android/ide/common/fonts/FontLoader;", "getInstance", "sdkHome", "Ljava/io/File;", "android.sdktools.sdk-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FontLoader getInstance(@Nullable File sdkHome) {
            if (instance == null) {
                instance = new FontLoader();
            }
            FontLoader fontLoader = instance;
            if (fontLoader == null) {
                Intrinsics.throwNpe();
            }
            fontLoader.clear(sdkHome);
            FontLoader fontLoader2 = instance;
            if (fontLoader2 == null) {
                Intrinsics.throwNpe();
            }
            return fontLoader2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

