/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.connection.settings;

import aQute.bnd.connection.settings.ProxyDTO;
import aQute.bnd.connection.settings.ServerDTO;
import aQute.bnd.connection.settings.SettingsDTO;
import aQute.bnd.util.dto.DTO;
import aQute.lib.converter.Converter;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SettingsParser {
    static final Converter cnv = new Converter();
    static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final XPathFactory xpf = XPathFactory.newInstance();
    final SettingsDTO settings = new SettingsDTO();
    final XPath xp;
    final Document doc;

    public SettingsParser(File file) throws Exception {
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.xp = xpf.newXPath();
        this.doc = db.parse(file);
        this.parse("/settings/proxies/proxy", ProxyDTO.class, this.settings.proxies);
        this.parse("/settings/servers/server", ServerDTO.class, this.settings.servers);
    }

    public SettingsDTO getSettings() {
        return this.settings;
    }

    <T extends DTO> void parse(String what, Class<T> type, List<T> map) throws XPathExpressionException, Exception {
        NodeList proxies = (NodeList)this.xp.evaluate(what, this.doc, XPathConstants.NODESET);
        for (int i = 0; i < proxies.getLength(); ++i) {
            Node node = proxies.item(i);
            DTO dto = (DTO)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.parse(node, dto);
            map.add(dto);
        }
    }

    <T extends DTO> void parse(Node node, T dto) throws Exception {
        for (Field f : dto.getClass().getFields()) {
            String value;
            if (Modifier.isStatic(f.getModifiers()) || (value = this.xp.evaluate(f.getName(), node)) == null || value.isEmpty()) continue;
            if (f.getType().isAnnotation()) {
                value = value.toUpperCase();
            }
            Object o = cnv.convert(f.getGenericType(), (Object)value);
            f.set(dto, o);
        }
    }
}

