/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.JvmWideVariable;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ReadWriteThreadLock {
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private static final ConcurrentMap<Object, ReentrantReadWriteLock> lockMap = new JvmWideVariable<ConcurrentMap>(ReadWriteThreadLock.class, "lockMap", new TypeToken<ConcurrentMap<Object, ReentrantReadWriteLock>>(){}, ConcurrentHashMap::new).get();
    private final ReentrantReadWriteLock lock;

    public ReadWriteThreadLock(Object lockObject) {
        Preconditions.checkArgument((lockObject.getClass().getClassLoader() == null ? 1 : 0) != 0, (Object)String.format("%1$s must be loaded by the bootstrap class loader but is loaded by %2$s", lockObject.getClass(), lockObject.getClass().getClassLoader()));
        this.lock = lockMap.computeIfAbsent(lockObject, any -> new ReentrantReadWriteLock());
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.writeLock().lock();
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.writeLock().unlock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.readLock().lock();
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.readLock().unlock();
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

