/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.Nullable;

public class PathUtils {
    @Nullable
    public static File convertToFile(URI uri) {
        if (uri == null) {
            return null;
        }
        String path = uri.getPath();
        if (path == null) {
            return null;
        }
        return new File(PathUtils.toURI(path));
    }

    public static URI toURI(String localPath) {
        try {
            String p = FileUtilRt.toSystemIndependentName((String)localPath);
            if (!p.startsWith("/")) {
                p = "/" + p;
            }
            if (!p.startsWith("//")) {
                p = "//" + p;
            }
            return new URI("file", null, p, null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }
}

