/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.gwt.build.GwtBuildTarget;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class GwtBuildTargetType
extends BuildTargetType<GwtBuildTarget> {
    public static final GwtBuildTargetType INSTANCE = new GwtBuildTargetType();
    public static final String TYPE_ID = "gwt";

    private GwtBuildTargetType() {
        super(TYPE_ID, true);
    }

    @NotNull
    public List<GwtBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            GwtBuildTargetType.$$$reportNull$$$0(0);
        }
        ArrayList<GwtBuildTarget> targets = new ArrayList<GwtBuildTarget>();
        JpsGwtExtensionService service = JpsGwtExtensionService.getInstance();
        for (JpsModule module : model.getProject().getModules()) {
            JpsGwtModuleExtension extension = service.getExtension(module);
            if (extension == null) continue;
            targets.add(new GwtBuildTarget(extension));
        }
        ArrayList<GwtBuildTarget> arrayList = targets;
        if (arrayList == null) {
            GwtBuildTargetType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<GwtBuildTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            GwtBuildTargetType.$$$reportNull$$$0(2);
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            GwtBuildTargetType.$$$reportNull$$$0(3);
        }
        return loader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/build/GwtBuildTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/build/GwtBuildTargetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Loader
    extends BuildTargetLoader<GwtBuildTarget> {
        private final Map<String, GwtBuildTarget> myTargets = new HashMap<String, GwtBuildTarget>();

        public Loader(JpsModel model) {
            JpsGwtExtensionService service = JpsGwtExtensionService.getInstance();
            for (JpsModule module : model.getProject().getModules()) {
                JpsGwtModuleExtension extension = service.getExtension(module);
                if (extension == null) continue;
                this.myTargets.put(module.getName(), new GwtBuildTarget(extension));
            }
        }

        @Nullable
        public GwtBuildTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                Loader.$$$reportNull$$$0(0);
            }
            return this.myTargets.get(targetId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/gwt/build/GwtBuildTargetType$Loader", "createTarget"));
        }
    }
}

