/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.jpm;

import aQute.bnd.jpm.Repository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Semaphore;

public class Crawler
extends Thread {
    boolean quit;
    private Repository repository;
    private Set<String> dls = new HashSet<String>();
    private Set<String> fails = new HashSet<String>();
    private Semaphore throttle = new Semaphore(2);

    public Crawler(Repository repository) {
        super(repository.getName());
        super.setDaemon(true);
        this.repository = repository;
    }

    @Override
    public void run() {
        block4: while (!this.quit) {
            try {
                if (!this.repository.offline) {
                    for (String bsn : this.repository.list(null)) {
                        SortedSet<Version> versions = this.repository.versions(bsn);
                        for (Version version : versions) {
                            final String key = bsn + "-" + version;
                            if (this.dls.contains(key)) continue;
                            this.throttle.acquire();
                            RepositoryPlugin.DownloadListener dl = new RepositoryPlugin.DownloadListener(){

                                public void success(File file) throws Exception {
                                    Crawler.this.throttle.release();
                                    Crawler.this.dls.remove(key);
                                }

                                public void failure(File file, String reason) throws Exception {
                                    Crawler.this.throttle.release();
                                    Crawler.this.fails.add(key);
                                    Crawler.this.dls.remove(key);
                                }

                                public boolean progress(File file, int percentage) throws Exception {
                                    return false;
                                }
                            };
                            if (!this.dls.contains(key)) {
                                this.dls.add(key);
                                this.repository.get(bsn, version, null, dl);
                            }
                            if (!Crawler.interrupted() && !this.repository.offline) continue;
                            continue block4;
                        }
                    }
                }
                Thread.sleep(500000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void close() {
        this.quit = true;
        this.interrupt();
    }

    public void refresh() {
        this.interrupt();
    }
}

