/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.UnexpectedFormElementException;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.LwButtonGroup;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwInspectionSuppression;
import com.intellij.uiDesigner.lw.LwXmlReader;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.lw.XYLayoutSerializer;
import java.util.ArrayList;
import org.jdom.Element;

public final class LwRootContainer
extends LwContainer
implements IRootContainer {
    private String myClassToBind;
    private String myMainComponentBinding;
    private final ArrayList myButtonGroups = new ArrayList();
    private final ArrayList myInspectionSuppressions = new ArrayList();

    public LwRootContainer() throws Exception {
        super("javax.swing.JPanel");
        this.myLayoutSerializer = XYLayoutSerializer.INSTANCE;
    }

    public String getMainComponentBinding() {
        return this.myMainComponentBinding;
    }

    @Override
    public String getClassToBind() {
        return this.myClassToBind;
    }

    public void setClassToBind(String classToBind) {
        this.myClassToBind = classToBind;
    }

    @Override
    public void read(Element element, PropertiesProvider provider) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        if (!"http://www.intellij.com/uidesigner/form/".equals(element.getNamespace().getURI())) {
            throw new AlienFormFileException();
        }
        if (!"form".equals(element.getName())) {
            throw new UnexpectedFormElementException("unexpected element: " + element);
        }
        this.setId("root");
        this.myClassToBind = element.getAttributeValue("bind-to-class");
        for (Element child : element.getChildren()) {
            if (child.getName().equals("buttonGroups")) {
                this.readButtonGroups(child);
                continue;
            }
            if (child.getName().equals("inspectionSuppressions")) {
                this.readInspectionSuppressions(child);
                continue;
            }
            LwComponent component = LwRootContainer.createComponentFromTag(child);
            this.addComponent(component);
            component.read(child, provider);
        }
        this.myMainComponentBinding = element.getAttributeValue("stored-main-component-binding");
    }

    private void readButtonGroups(Element element) {
        for (Element child : element.getChildren()) {
            LwButtonGroup group = new LwButtonGroup();
            group.read(child);
            this.myButtonGroups.add(group);
        }
    }

    private void readInspectionSuppressions(Element element) {
        for (Element child : element.getChildren()) {
            String inspectionId = LwXmlReader.getRequiredString(child, "inspection");
            String componentId = LwXmlReader.getString(child, "id");
            this.myInspectionSuppressions.add(new LwInspectionSuppression(inspectionId, componentId));
        }
    }

    @Override
    public IButtonGroup[] getButtonGroups() {
        return this.myButtonGroups.toArray(new LwButtonGroup[0]);
    }

    @Override
    public String getButtonGroupName(IComponent component) {
        for (int i = 0; i < this.myButtonGroups.size(); ++i) {
            LwButtonGroup group = (LwButtonGroup)this.myButtonGroups.get(i);
            String[] ids = group.getComponentIds();
            for (int j = 0; j < ids.length; ++j) {
                if (!ids[j].equals(component.getId())) continue;
                return group.getName();
            }
        }
        return null;
    }

    @Override
    public String[] getButtonGroupComponentIds(String groupName) {
        for (int i = 0; i < this.myButtonGroups.size(); ++i) {
            LwButtonGroup group = (LwButtonGroup)this.myButtonGroups.get(i);
            if (!group.getName().equals(groupName)) continue;
            return group.getComponentIds();
        }
        throw new IllegalArgumentException("Cannot find group " + groupName);
    }

    @Override
    public boolean isInspectionSuppressed(String inspectionId, String componentId) {
        for (LwInspectionSuppression suppression : this.myInspectionSuppressions) {
            if (suppression.getComponentId() != null && !suppression.getComponentId().equals(componentId) || !suppression.getInspectionId().equals(inspectionId)) continue;
            return true;
        }
        return false;
    }

    public LwInspectionSuppression[] getInspectionSuppressions() {
        return this.myInspectionSuppressions.toArray(LwInspectionSuppression.EMPTY_ARRAY);
    }
}

