/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PathUtils {
    private PathUtils() {
    }

    public static void deleteIfExists(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    public static String toSystemIndependentPath(Path path) {
        String filePath = path.toString();
        if (!path.getFileSystem().getSeparator().equals("/")) {
            return filePath.replace(path.getFileSystem().getSeparator(), "/");
        }
        return filePath;
    }

    public static Path createTmpToRemoveOnShutdown(String prefix) throws IOException {
        Path tmpFile = Files.createTempFile(prefix, "", new FileAttribute[0]);
        PathUtils.addRemovePathHook(tmpFile);
        return tmpFile;
    }

    public static Path createTmpDirToRemoveOnShutdown(String prefix) throws IOException {
        Path tmpDir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        PathUtils.addRemovePathHook(tmpDir);
        return tmpDir;
    }

    public static List<Path> getClassPathItems(String classPath) {
        Iterable components = Splitter.on((String)File.pathSeparator).split((CharSequence)classPath);
        ArrayList classPathJars = Lists.newArrayList();
        PathMatcher zipOrJar = FileSystems.getDefault().getPathMatcher(String.format("glob:**{%s,%s}", "zip", "jar"));
        for (String component : components) {
            Path componentPath = Paths.get(component, new String[0]);
            if (Files.isRegularFile(componentPath, new LinkOption[0])) {
                classPathJars.add(componentPath);
                continue;
            }
            try {
                Files.walk(componentPath, new FileVisitOption[0]).filter(zipOrJar::matches).forEach(classPathJars::add);
            }
            catch (IOException iOException) {}
        }
        return classPathJars;
    }

    private static void addRemovePathHook(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                PathUtils.deleteIfExists(path);
            }
            catch (IOException e) {
                Logger.getLogger(PathUtils.class.getName()).log(Level.WARNING, "Unable to delete " + path, e);
            }
        }));
    }
}

