/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.Registry;
import aQute.bnd.service.Strategy;
import biz.aQute.resolve.BndrunResolveContext;
import biz.aQute.resolve.ResolutionCallback;
import biz.aQute.resolve.ResolveProcess;
import biz.aQute.resolve.WorkspaceResourcesRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.log.LogService;
import org.osgi.service.resolver.ResolutionException;

public class ProjectResolver
extends Processor
implements ResolutionCallback {
    private Project project;
    private Map<Resource, List<Wire>> resolution;
    private ReporterLogger log = new ReporterLogger(0);
    private ResolverImpl resolver = new ResolverImpl((Logger)new ReporterLogger(0), null);
    private ResolveProcess resolve = new ResolveProcess();
    private Collection<ResolutionCallback> cbs = new ArrayList<ResolutionCallback>();

    public ProjectResolver(Project project) throws Exception {
        super((Processor)project);
        this.getSettings((Processor)project);
        this.project = project;
        Workspace workspace = project.getWorkspace();
        if (workspace != null) {
            this.addBasicPlugin((Object)new WorkspaceResourcesRepository(workspace));
        }
    }

    public Map<Resource, List<Wire>> resolve() throws ResolutionException {
        this.resolution = this.resolve.resolveRequired((Processor)this.project, this.project, (Registry)this, this.resolver, this.cbs, this.log);
        return this.resolution;
    }

    @Override
    public void processCandidates(Requirement requirement, Set<Capability> wired, List<Capability> candidates) {
    }

    public List<Container> getRunBundles() throws Exception {
        if (this.resolution == null) {
            this.resolve();
        }
        ArrayList<Container> containers = new ArrayList<Container>();
        for (Resource r : this.resolution.keySet()) {
            ResourceUtils.IdentityCapability identity = ResourceUtils.getIdentityCapability((Resource)r);
            if (identity == null) {
                this.error("Identity for %s not found", new Object[]{r});
                continue;
            }
            Container bundle = this.project.getBundle(identity.osgi_identity(), identity.version().toString(), Strategy.EXACT, null);
            if (bundle == null) {
                this.error("Bundle for %s-%s not found", new Object[]{identity.osgi_identity(), identity.version()});
                continue;
            }
            containers.add(bundle);
        }
        return containers;
    }

    public void validate() throws Exception {
        BndrunResolveContext context = this.getContext();
        String runrequires = this.project.getProperty("-runrequires");
        if (runrequires == null || runrequires.isEmpty()) {
            this.error("Requires the %s instruction to be set", new Object[]{"-runrequires"});
        } else {
            if ("<<EMPTY>>".equals(runrequires)) {
                return;
            }
            this.exists(context, runrequires, "Initial requirement %s cannot be resolved to an entry in the repositories");
        }
        String framework = this.project.getProperty("-runfw");
        if (framework == null) {
            this.error("No framework is set", new Object[0]);
        } else {
            this.exists(context, framework, "Framework not found");
        }
    }

    private void exists(BndrunResolveContext context, String framework, String msg) throws Exception {
        Parameters p = new Parameters(framework);
        for (Map.Entry e : p.entrySet()) {
            this.exists(context, (String)e.getKey(), (Attrs)e.getValue(), msg);
        }
    }

    private void exists(BndrunResolveContext context, String namespace, Attrs attrs, String msg) throws Exception {
        Requirement req = CapReqBuilder.getRequirementFrom((String)namespace, (Attrs)attrs);
        List<Capability> caps = context.findProviders(req);
        if (caps == null || caps.isEmpty()) {
            this.error(msg, new Object[]{req});
        }
    }

    public BndrunResolveContext getContext() {
        return new BndrunResolveContext((Processor)this.project, this.project, (Registry)this, this.log);
    }

    public ResourceUtils.IdentityCapability getResource(String bsn, String version) {
        Requirement requirement = CapReqBuilder.createBundleRequirement((String)bsn, (String)version).buildSyntheticRequirement();
        List<Capability> result = this.getContext().findProviders(requirement);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return ResourceUtils.getIdentityCapability((Resource)result.get(0).getResource());
    }

    private final class ReporterLogger
    extends Logger
    implements LogService {
        ReporterLogger(int i) {
            super(i);
        }

        @Override
        protected void doLog(int level, String msg, Throwable throwable) {
            String format = throwable == null ? "%s" : "%s: %s";
            switch (level) {
                case 0: {
                    ProjectResolver.this.error(format, new Object[]{msg, throwable});
                    break;
                }
                case 1: {
                    ProjectResolver.this.warning(format, new Object[]{msg, throwable});
                    break;
                }
                default: {
                    ProjectResolver.this.trace(format, new Object[]{msg, throwable});
                }
            }
        }

        @Override
        public void log(ServiceReference sr, int level, String message) {
            this.doLog(level, this.toString(sr) + message, null);
        }

        @Override
        public void log(ServiceReference sr, int level, String message, Throwable exception) {
            this.doLog(level, this.toString(sr) + message, exception);
        }

        private String toString(ServiceReference<?> sr) {
            return "[" + sr.getProperty("service.id") + "] ";
        }
    }
}

