/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.run;

public class InstantAppRunException
extends Exception {
    private final ErrorType myErrorType;

    InstantAppRunException(ErrorType errorType) {
        super(InstantAppRunException.createMessageForError(errorType));
        this.myErrorType = errorType;
    }

    InstantAppRunException(ErrorType errorType, Throwable cause) {
        super(InstantAppRunException.createMessageForError(errorType) + " Caused by: " + cause.getMessage(), cause);
        this.myErrorType = errorType;
    }

    InstantAppRunException(ErrorType errorType, String message) {
        super(InstantAppRunException.createMessageForError(errorType) + " " + message);
        this.myErrorType = errorType;
    }

    InstantAppRunException(ErrorType errorType, String message, Throwable cause) {
        super(InstantAppRunException.createMessageForError(errorType) + " " + message + " Caused by: " + cause.getMessage(), cause);
        this.myErrorType = errorType;
    }

    private static String createMessageForError(ErrorType errorType) {
        switch (errorType) {
            case READ_IAPK_TIMEOUT: {
                return "Reading bundle timed out.";
            }
            case READ_IAPK_FAILED: {
                return "Failure when trying to read bundle.";
            }
            case NO_GOOGLE_ACCOUNT: {
                return "Device is not logged in a Google account.";
            }
            case SHELL_TIMEOUT: {
                return "Shell adb command has timed out.";
            }
            case ADB_FAILURE: {
                return "ADB has failed.";
            }
            case INSTALL_FAILED: {
                return "Installing APK failed.";
            }
            case CANCELLED: {
                return "Cancelled by the user.";
            }
            case UNKNOWN: {
                return "Error while deploying Instant App.";
            }
        }
        return null;
    }

    public ErrorType getErrorType() {
        return this.myErrorType;
    }

    public static enum ErrorType {
        READ_IAPK_TIMEOUT,
        READ_IAPK_FAILED,
        NO_GOOGLE_ACCOUNT,
        SHELL_TIMEOUT,
        ADB_FAILURE,
        INSTALL_FAILED,
        CANCELLED,
        UNKNOWN;

    }
}

