/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerOptionInfo {
    public static final String LIST_ENTRIES_SEPARATOR = "\n";
    public static final String LIST_ENTRY_PARTS_SEPARATOR = "\t";
    public static final String FLEX_SDK_MACRO_NAME = "FLEX_SDK";
    public static final String FLEX_SDK_MACRO = "${FLEX_SDK}";
    private static final String SPECIAL_DEFAULT_VALUE = "SPECIAL";
    private static final Logger LOG = Logger.getInstance((String)CompilerOptionInfo.class.getName());
    private static volatile CompilerOptionInfo[] ourRootInfos;
    private static final Map<String, CompilerOptionInfo> ourIdToInfoMap;
    private static final Collection<CompilerOptionInfo> ourOptionsWithSpecialValues;
    public static final CompilerOptionInfo DEBUG_INFO;
    public static final CompilerOptionInfo EXTERNAL_LIBRARY_INFO;
    public static final CompilerOptionInfo LIBRARY_PATH_INFO;
    public static final CompilerOptionInfo INCLUDE_LIBRARY_INFO;
    public static final CompilerOptionInfo SOURCE_PATH_INFO;
    public static final CompilerOptionInfo INCLUDE_CLASSES_INFO;
    public static final CompilerOptionInfo RSL_ONE_URL_PATH_INFO;
    public static final CompilerOptionInfo RSL_TWO_URLS_PATH_INFO;
    public static final CompilerOptionInfo MOBILE_INFO;
    public static final CompilerOptionInfo TARGET_PLAYER_INFO;
    public static final CompilerOptionInfo MAIN_CLASS_INFO;
    public static final CompilerOptionInfo OUTPUT_PATH_INFO;
    public static final CompilerOptionInfo ACCESSIBLE_INFO;
    public static final CompilerOptionInfo PRELOADER_INFO;
    public static final CompilerOptionInfo WARN_NO_CONSTRUCTOR_INFO;
    public static final CompilerOptionInfo LINK_REPORT_INFO;
    public static final CompilerOptionInfo LOAD_EXTERNS_INFO;
    public static final CompilerOptionInfo FONT_MANAGERS_INFO;
    public static final CompilerOptionInfo SWF_VERSION_INFO;
    public static final CompilerOptionInfo STATIC_RSLS_INFO;
    public static final CompilerOptionInfo INCLUDE_NAMESPACES_INFO;
    public static final CompilerOptionInfo RLMS_INFO_FOR_UI;
    public static final CompilerOptionInfo CSS_FILES_INFO_FOR_UI;
    public static final CompilerOptionInfo INCLUDE_FILE_INFO_FOR_UI;
    public static final CompilerOptionInfo INCLUDE_FILE_INFO;
    public final String ID;
    public final String DISPLAY_NAME;
    public final OptionType TYPE;
    @Nullable
    public final String FILE_EXTENSION;
    public final ListElement[] LIST_ELEMENTS;
    public final boolean ADVANCED;
    private final CompilerOptionInfo[] myChildOptionInfos;
    @Nullable
    private final String mySinceVersion;
    private final boolean myOkForAir;
    private final boolean myOkForPureAS;
    private final boolean myOkForSwf;
    private final boolean myOkForSwc;
    private final String myDefaultValue;

    private CompilerOptionInfo(@NotNull String id, @NotNull String displayName, @NotNull OptionType optionType, @Nullable String fileExtension, @Nullable ListElement[] listElements, boolean advanced, @Nullable String sinceVersion, boolean okForAir, boolean okForPureAS, boolean okForSwf, boolean okForSwc, String defaultValue) {
        if (id == null) {
            CompilerOptionInfo.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            CompilerOptionInfo.$$$reportNull$$$0(1);
        }
        if (optionType == null) {
            CompilerOptionInfo.$$$reportNull$$$0(2);
        }
        assert (optionType != OptionType.Group);
        this.ID = id;
        this.DISPLAY_NAME = displayName;
        this.TYPE = optionType;
        this.FILE_EXTENSION = fileExtension;
        this.LIST_ELEMENTS = listElements;
        this.ADVANCED = advanced;
        this.mySinceVersion = sinceVersion;
        this.myOkForAir = okForAir;
        this.myOkForPureAS = okForPureAS;
        this.myOkForSwf = okForSwf;
        this.myOkForSwc = okForSwc;
        this.myDefaultValue = defaultValue;
        this.myChildOptionInfos = null;
    }

    private CompilerOptionInfo(@NotNull String groupDisplayName, boolean advanced, @Nullable String sinceVersion, boolean okForAir, boolean okForPureAS, boolean okForSwf, boolean okForSwc, CompilerOptionInfo[] childOptionInfos) {
        if (groupDisplayName == null) {
            CompilerOptionInfo.$$$reportNull$$$0(3);
        }
        this.ID = null;
        this.DISPLAY_NAME = groupDisplayName;
        this.TYPE = OptionType.Group;
        this.FILE_EXTENSION = null;
        this.LIST_ELEMENTS = null;
        this.ADVANCED = advanced;
        this.mySinceVersion = sinceVersion;
        this.myOkForAir = okForAir;
        this.myOkForPureAS = okForPureAS;
        this.myOkForSwf = okForSwf;
        this.myOkForSwc = okForSwc;
        this.myDefaultValue = null;
        this.myChildOptionInfos = childOptionInfos;
    }

    public boolean isGroup() {
        return this.TYPE == OptionType.Group;
    }

    public boolean isApplicable(String sdkVersion, BuildConfigurationNature nature) {
        if (this.mySinceVersion != null && !sdkVersion.startsWith("AIR SDK ") && StringUtil.compareVersionNumbers((String)sdkVersion, (String)this.mySinceVersion) < 0) {
            return false;
        }
        if (!this.myOkForPureAS && nature.pureAS) {
            return false;
        }
        if (!this.myOkForSwf && !nature.isLib()) {
            return false;
        }
        return this.myOkForSwc || !nature.isLib();
    }

    public CompilerOptionInfo[] getChildOptionInfos() {
        assert (this.TYPE == OptionType.Group);
        return this.myChildOptionInfos;
    }

    public static CompilerOptionInfo[] getRootInfos() {
        CompilerOptionInfo.ensureLoaded();
        return ourRootInfos;
    }

    public static CompilerOptionInfo getOptionInfo(String id) {
        CompilerOptionInfo.ensureLoaded();
        CompilerOptionInfo info = ourIdToInfoMap.get(id);
        assert (info != null) : id;
        return info;
    }

    public static boolean idExists(String id) {
        CompilerOptionInfo.ensureLoaded();
        return ourIdToInfoMap.get(id) != null;
    }

    public String getDefaultValue(String sdkVersion, BuildConfigurationNature nature, ComponentSet componentSet) {
        assert (!this.isGroup()) : this.DISPLAY_NAME;
        if (SPECIAL_DEFAULT_VALUE.equals(this.myDefaultValue)) {
            if (this.ID.startsWith("compiler.debug")) {
                return "true";
            }
            if ("compiler.locale".equals(this.ID)) {
                return "en_US";
            }
            if ("compiler.theme".equals(this.ID)) {
                if (!(nature.pureAS || nature.isDesktopPlatform() || sdkVersion.startsWith("AIR SDK ") || StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4") < 0)) {
                    if (nature.isMobilePlatform()) {
                        return "${FLEX_SDK}/frameworks/themes/Mobile/mobile.swc";
                    }
                    if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4") >= 0 && componentSet == ComponentSet.MxOnly) {
                        return "${FLEX_SDK}/frameworks/themes/Halo/halo.swc";
                    }
                    return "${FLEX_SDK}/frameworks/themes/Spark/spark.css";
                }
                return "";
            }
            assert (false) : this.ID;
        }
        return this.myDefaultValue;
    }

    public static Collection<CompilerOptionInfo> getOptionsWithSpecialValues() {
        CompilerOptionInfo.ensureLoaded();
        return ourOptionsWithSpecialValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureLoaded() {
        if (ourRootInfos != null) return;
        Class<CompilerOptionInfo> clazz = CompilerOptionInfo.class;
        synchronized (CompilerOptionInfo.class) {
            if (ourRootInfos != null) return;
            CompilerOptionInfo.loadInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void loadInfo() {
        try {
            ArrayList<CompilerOptionInfo> infos = new ArrayList<CompilerOptionInfo>(30);
            Element rootElement = JDOMUtil.load((InputStream)CompilerOptionInfo.class.getResourceAsStream("flex-compiler-options.xml"));
            assert (rootElement != null);
            assert ("options".equals(rootElement.getName()));
            for (Element element : rootElement.getChildren()) {
                CompilerOptionInfo info;
                if ("group".equals(element.getName())) {
                    info = CompilerOptionInfo.loadGroup(element);
                } else {
                    assert ("option".equals(element.getName()));
                    info = CompilerOptionInfo.loadOption(element);
                }
                infos.add(info);
            }
            ourRootInfos = infos.toArray(new CompilerOptionInfo[0]);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static CompilerOptionInfo loadGroup(Element groupElement) {
        String displayName = groupElement.getAttributeValue("displayName");
        assert (StringUtil.isNotEmpty((String)displayName));
        String advancedValue = groupElement.getAttributeValue("advanced");
        boolean advanced = advancedValue != null && "true".equals(advancedValue);
        String since = groupElement.getAttributeValue("since");
        String okForAirValue = groupElement.getAttributeValue("okForAir");
        boolean okForAir = okForAirValue == null || "false".equals(okForAirValue);
        String okForPureASValue = groupElement.getAttributeValue("okForPureAS");
        boolean okForPureAS = okForPureASValue == null || "false".equals(okForPureASValue);
        String okForSWFValue = groupElement.getAttributeValue("okForSWF");
        boolean okForSWF = okForSWFValue == null || "false".equals(okForSWFValue);
        String okForSWCValue = groupElement.getAttributeValue("okForSWC");
        boolean okForSWC = okForSWCValue == null || "false".equals(okForSWCValue);
        ArrayList<CompilerOptionInfo> infos = new ArrayList<CompilerOptionInfo>();
        for (Element element : groupElement.getChildren()) {
            CompilerOptionInfo info;
            if ("group".equals(element.getName())) {
                info = CompilerOptionInfo.loadGroup(element);
            } else {
                assert ("option".equals(element.getName()));
                info = CompilerOptionInfo.loadOption(element);
            }
            infos.add(info);
        }
        CompilerOptionInfo[] infosArray = infos.toArray(new CompilerOptionInfo[0]);
        return new CompilerOptionInfo(displayName, advanced, since, okForAir, okForPureAS, okForSWF, okForSWC, infosArray);
    }

    private static CompilerOptionInfo loadOption(Element element) {
        String id = element.getAttributeValue("id");
        assert (StringUtil.isNotEmpty((String)id));
        String displayName = element.getAttributeValue("displayName");
        assert (StringUtil.isNotEmpty((String)displayName));
        String typeValue = element.getAttributeValue("type");
        OptionType type = OptionType.valueOf(typeValue);
        assert (type != OptionType.Group);
        String fileExtension = type == OptionType.File ? element.getAttributeValue("fileExtension") : null;
        ListElement[] listElements = type == OptionType.List ? CompilerOptionInfo.readListElements(element) : null;
        String advancedValue = element.getAttributeValue("advanced");
        boolean advanced = advancedValue != null && "true".equals(advancedValue);
        String since = element.getAttributeValue("since");
        String okForAirValue = element.getAttributeValue("okForAir");
        boolean okForAir = okForAirValue == null || "true".equals(okForAirValue);
        String okForPureASValue = element.getAttributeValue("okForPureAS");
        boolean okForPureAS = okForPureASValue == null || "true".equals(okForPureASValue);
        String okForSWFValue = element.getAttributeValue("okForSWF");
        boolean okForSWF = okForSWFValue == null || "true".equals(okForSWFValue);
        String okForSWCValue = element.getAttributeValue("okForSWC");
        boolean okForSWC = okForSWCValue == null || "true".equals(okForSWCValue);
        String defaultValue = StringUtil.notNullize((String)element.getAttributeValue("default"));
        CompilerOptionInfo info = new CompilerOptionInfo(id, displayName, type, fileExtension, listElements, advanced, since, okForAir, okForPureAS, okForSWF, okForSWC, defaultValue);
        if (SPECIAL_DEFAULT_VALUE.equals(defaultValue)) {
            ourOptionsWithSpecialValues.add(info);
        }
        ourIdToInfoMap.put(id, info);
        return info;
    }

    private static ListElement[] readListElements(Element element) {
        LinkedList<ListElement> result = new LinkedList<ListElement>();
        for (Element childElement : element.getChildren("listElement")) {
            String name = childElement.getAttributeValue("name");
            String displayName = childElement.getAttributeValue("displayName");
            assert (name != null) : element.getName();
            ListElementType listElementType = ListElementType.valueOf(childElement.getAttributeValue("type"));
            String fileExtensionRaw = childElement.getAttributeValue("fileExtensions");
            String[] fileExtensions = fileExtensionRaw == null ? null : fileExtensionRaw.split(",");
            String defaultValue = StringUtil.notNullize((String)childElement.getAttributeValue("default"));
            result.add(new ListElement(name, displayName, listElementType, fileExtensions, defaultValue));
        }
        assert (!result.isEmpty()) : element.getName();
        return result.toArray(new ListElement[0]);
    }

    public String toString() {
        return this.ID;
    }

    static {
        ourIdToInfoMap = new THashMap(50);
        ourOptionsWithSpecialValues = new LinkedList<CompilerOptionInfo>();
        DEBUG_INFO = new CompilerOptionInfo("compiler.debug", "fake", OptionType.Boolean, null, null, false, null, true, true, true, true, "");
        EXTERNAL_LIBRARY_INFO = new CompilerOptionInfo("compiler.external-library-path", "fake", OptionType.List, null, new ListElement[]{new ListElement("path-element")}, false, null, true, true, true, true, "");
        LIBRARY_PATH_INFO = new CompilerOptionInfo("compiler.library-path", "fake", OptionType.List, null, new ListElement[]{new ListElement("path-element")}, false, null, true, true, true, true, "");
        INCLUDE_LIBRARY_INFO = new CompilerOptionInfo("compiler.include-libraries", "fake", OptionType.List, null, new ListElement[]{new ListElement("library")}, false, null, true, true, true, true, "");
        SOURCE_PATH_INFO = new CompilerOptionInfo("compiler.source-path", "fake", OptionType.List, null, new ListElement[]{new ListElement("path-element")}, false, null, true, true, true, true, "");
        INCLUDE_CLASSES_INFO = new CompilerOptionInfo("include-classes", "fake", OptionType.List, null, new ListElement[]{new ListElement("class")}, false, null, true, true, true, true, "");
        RSL_ONE_URL_PATH_INFO = new CompilerOptionInfo("runtime-shared-library-path", "fake", OptionType.List, null, new ListElement[]{new ListElement("path-element"), new ListElement("rsl-url"), new ListElement("policy-file-url")}, false, null, true, true, true, true, "");
        RSL_TWO_URLS_PATH_INFO = new CompilerOptionInfo("runtime-shared-library-path", "fake", OptionType.List, null, new ListElement[]{new ListElement("path-element"), new ListElement("rsl-url"), new ListElement("policy-file-url"), new ListElement("rsl-url"), new ListElement("policy-file-url")}, false, null, true, true, true, true, "");
        MOBILE_INFO = new CompilerOptionInfo("compiler.mobile", "fake", OptionType.Boolean, null, null, false, null, true, true, true, true, "");
        TARGET_PLAYER_INFO = new CompilerOptionInfo("target-player", "fake", OptionType.String, null, null, false, null, true, true, true, true, "");
        MAIN_CLASS_INFO = new CompilerOptionInfo("file-specs.path-element", "fake", OptionType.String, null, null, false, null, true, true, true, true, "");
        OUTPUT_PATH_INFO = new CompilerOptionInfo("output", "fake", OptionType.String, null, null, false, null, true, true, true, true, "");
        ACCESSIBLE_INFO = new CompilerOptionInfo("compiler.accessible", "fake", OptionType.Boolean, null, null, false, null, true, true, true, true, "");
        PRELOADER_INFO = new CompilerOptionInfo("compiler.preloader", "fake", OptionType.String, null, null, false, "4.5", true, true, true, true, "");
        WARN_NO_CONSTRUCTOR_INFO = new CompilerOptionInfo("compiler.warn-no-constructor", "fake", OptionType.Boolean, null, null, false, null, true, true, true, true, "");
        LINK_REPORT_INFO = new CompilerOptionInfo("link-report", "fake", OptionType.File, "xml", null, false, null, true, true, true, true, "");
        LOAD_EXTERNS_INFO = new CompilerOptionInfo("load-externs", "fake", OptionType.File, "xml", null, false, null, true, true, true, true, "");
        FONT_MANAGERS_INFO = new CompilerOptionInfo("compiler.fonts.managers", "fake", OptionType.List, null, new ListElement[]{new ListElement("manager-class")}, false, null, true, true, true, true, "");
        SWF_VERSION_INFO = new CompilerOptionInfo("swf-version", "fake", OptionType.String, null, null, false, "4.5", true, true, true, true, "");
        STATIC_RSLS_INFO = new CompilerOptionInfo("static-link-runtime-shared-libraries", "fake", OptionType.Boolean, null, null, false, null, true, true, true, true, "");
        INCLUDE_NAMESPACES_INFO = new CompilerOptionInfo("include-namespaces", "fake", OptionType.List, null, new ListElement[]{new ListElement("uri")}, false, null, true, true, true, true, "");
        RLMS_INFO_FOR_UI = new CompilerOptionInfo("rlm.list.fake", "fake", OptionType.List, null, new ListElement[]{new ListElement("fake", "Main Class", ListElementType.Class, null, ""), new ListElement("fake", "Output File", ListElementType.String, null, ""), new ListElement("fake", "Optimize", ListElementType.Boolean, null, "true")}, false, null, true, true, true, true, "");
        CSS_FILES_INFO_FOR_UI = new CompilerOptionInfo("css.files.list.fake", "fake", OptionType.List, null, new ListElement[]{new ListElement("fake", "CSS Files", ListElementType.File, new String[]{"css"}, "")}, false, null, true, true, true, true, "");
        INCLUDE_FILE_INFO_FOR_UI = new CompilerOptionInfo("files.to.include.in.swc.fake", "fake", OptionType.List, null, new ListElement[]{new ListElement("fake", "Files And Folders", ListElementType.FileOrFolder, null, "")}, false, null, true, true, true, true, "");
        INCLUDE_FILE_INFO = new CompilerOptionInfo("include-file", "fake", OptionType.List, null, new ListElement[]{new ListElement("name"), new ListElement("path")}, false, null, true, true, true, true, "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "id";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "displayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "optionType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "groupDisplayName";
                break;
            }
        }
        objectArray[1] = "com/intellij/flex/model/bc/CompilerOptionInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ListElement {
        public final String NAME;
        public final String DISPLAY_NAME;
        public final ListElementType LIST_ELEMENT_TYPE;
        @Nullable
        public final String[] FILE_EXTENSIONS;
        public final String DEFAULT_VALUE;

        private ListElement(String name) {
            this(name, "", ListElementType.String, null, "");
        }

        private ListElement(String name, String displayName, ListElementType listElementType, @Nullable String[] fileExtensions, String defaultValue) {
            this.NAME = name;
            this.DISPLAY_NAME = displayName;
            this.LIST_ELEMENT_TYPE = listElementType;
            this.FILE_EXTENSIONS = fileExtensions;
            this.DEFAULT_VALUE = defaultValue;
        }
    }

    public static enum ListElementType {
        String,
        File,
        FileOrFolder,
        Class,
        Boolean,
        Locale;

    }

    public static enum OptionType {
        Group,
        Boolean,
        String,
        Int,
        File,
        List,
        IncludeClasses,
        IncludeFiles;

    }
}

