/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.classpath;

import com.springsource.bundlor.ClassPath;
import com.springsource.bundlor.ClassPathEntry;
import com.springsource.bundlor.support.classpath.JarFileClassPathEntry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JarFileClassPath
implements ClassPath {
    private final JarFile jarFile;

    public JarFileClassPath(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public Iterator<ClassPathEntry> iterator() {
        return new JarFileClassPathIterator(this.jarFile);
    }

    @Override
    public ClassPathEntry getEntry(String name) {
        JarEntry entry = this.jarFile.getJarEntry(name);
        if (entry != null) {
            return new JarFileClassPathEntry(this.jarFile, entry);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {}
    }

    public String toString() {
        return this.jarFile.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarFileClassPathIterator
    implements Iterator<ClassPathEntry> {
        private final JarFile jarFile;
        private final Enumeration<JarEntry> jarEntryEnumeration;

        public JarFileClassPathIterator(JarFile jarFile) {
            this.jarFile = jarFile;
            this.jarEntryEnumeration = jarFile.entries();
        }

        @Override
        public boolean hasNext() {
            return this.jarEntryEnumeration.hasMoreElements();
        }

        @Override
        public ClassPathEntry next() {
            return new JarFileClassPathEntry(this.jarFile, this.jarEntryEnumeration.nextElement());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

