/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.bnd.service.url.State;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.maven.api.Archive;
import aQute.maven.api.IMavenRepo;
import aQute.maven.api.Program;
import aQute.maven.api.Release;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenBackingRepository;
import aQute.maven.provider.POM;
import aQute.maven.provider.Releaser;
import aQute.maven.provider.SnapshotReleaser;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.osgi.util.function.Function;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;

public class MavenRepository
implements IMavenRepo,
Closeable {
    private final File base;
    private final String id;
    private final List<MavenBackingRepository> release = new ArrayList<MavenBackingRepository>();
    private final List<MavenBackingRepository> snapshot = new ArrayList<MavenBackingRepository>();
    private final Executor executor;
    private final boolean localOnly;
    private final Reporter reporter = new Slf4jReporter(MavenRepository.class);
    private final Map<Revision, Promise<POM>> poms = new WeakHashMap<Revision, Promise<POM>>();

    public MavenRepository(File base, String id, List<MavenBackingRepository> release, List<MavenBackingRepository> snapshot, Executor executor, Reporter reporter, Callable<Boolean> callback) throws Exception {
        this.base = base;
        this.id = id;
        if (release != null) {
            this.release.addAll(release);
        }
        if (snapshot != null) {
            this.snapshot.addAll(snapshot);
        }
        this.executor = executor == null ? Executors.newCachedThreadPool() : executor;
        this.localOnly = this.release.isEmpty() && this.snapshot.isEmpty();
        base.mkdirs();
    }

    @Override
    public List<Revision> getRevisions(Program program) throws Exception {
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        for (MavenBackingRepository mbr : this.release) {
            mbr.getRevisions(program, revisions);
        }
        for (MavenBackingRepository mbr : this.snapshot) {
            if (this.release.contains(mbr)) continue;
            mbr.getRevisions(program, revisions);
        }
        return revisions;
    }

    @Override
    public List<Archive> getSnapshotArchives(Revision revision) throws Exception {
        if (!revision.isSnapshot()) {
            return null;
        }
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (MavenBackingRepository mbr : this.snapshot) {
            List<Archive> snapshotArchives = mbr.getSnapshotArchives(revision);
            archives.addAll(snapshotArchives);
        }
        return archives;
    }

    @Override
    public Archive getResolvedArchive(Revision revision, String extension, String classifier) throws Exception {
        if (revision.isSnapshot()) {
            for (MavenBackingRepository mbr : this.snapshot) {
                MavenVersion v = mbr.getVersion(revision);
                if (v == null) continue;
                return revision.archive(v, extension, classifier);
            }
            return null;
        }
        return revision.archive(extension, classifier);
    }

    @Override
    public Release release(Revision revision, Properties context) throws Exception {
        this.reporter.trace("Release %s to %s", new Object[]{revision, this});
        if (revision.isSnapshot()) {
            return new SnapshotReleaser(this, revision, this.snapshot.isEmpty() ? null : this.snapshot.get(0), context);
        }
        return new Releaser(this, revision, this.release.isEmpty() ? null : this.release.get(0), context);
    }

    @Override
    public Promise<File> get(Archive archive) throws Exception {
        return this.get(archive, true);
    }

    private Promise<File> get(final Archive archive, final boolean thrw) throws Exception {
        final File file = this.toLocalFile(archive);
        if (file.isFile() && !archive.isSnapshot()) {
            return Promises.resolved((Object)file);
        }
        if (this.localOnly || this.isFresh(file)) {
            return Promises.resolved((Object)(file.isFile() ? file : null));
        }
        final Deferred deferred = new Deferred();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    File f = MavenRepository.this.getFile(archive, file);
                    if (thrw && f == null) {
                        deferred.fail((Throwable)new FileNotFoundException("For Maven artifact " + archive));
                        return;
                    }
                    deferred.resolve((Object)f);
                }
                catch (Throwable e) {
                    deferred.fail(e);
                }
            }
        });
        return deferred.getPromise();
    }

    private boolean isFresh(File file) {
        if (!file.isFile()) {
            return false;
        }
        long now = System.currentTimeMillis();
        long diff = now - file.lastModified();
        return diff < TimeUnit.DAYS.toMillis(1L);
    }

    File getFile(Archive archive, File file) throws Exception {
        State result = null;
        if (archive.isSnapshot()) {
            Archive resolved = this.resolveSnapshot(archive);
            if (resolved == null) {
                if (file.isFile()) {
                    return file;
                }
                return null;
            }
            if (resolved != null) {
                result = this.fetch(this.snapshot, resolved.remotePath, file);
            }
        }
        if (result == null && this.release != null) {
            result = this.fetch(this.release, archive.remotePath, file);
        }
        if (result == null) {
            throw new IllegalStateException("Neither release nor remote repo set");
        }
        switch (result) {
            case NOT_FOUND: {
                return null;
            }
            case OTHER: {
                throw new IOException("Could not fetch " + archive.toString());
            }
        }
        return file;
    }

    private State fetch(List<MavenBackingRepository> mbrs, String remotePath, File file) throws Exception {
        State error = State.NOT_FOUND;
        for (MavenBackingRepository mbr : mbrs) {
            TaggedData fetch = mbr.fetch(remotePath, file);
            switch (fetch.getState()) {
                case NOT_FOUND: {
                    break;
                }
                case OTHER: {
                    error = State.OTHER;
                    this.reporter.error("Fetching artifact gives error %s", new Object[]{remotePath});
                    break;
                }
                case UNMODIFIED: 
                case UPDATED: {
                    return fetch.getState();
                }
            }
        }
        return error;
    }

    @Override
    public Archive resolveSnapshot(Archive archive) throws Exception {
        if (archive.isResolved()) {
            return archive;
        }
        for (MavenBackingRepository mbr : this.snapshot) {
            MavenVersion version = mbr.getVersion(archive.revision);
            if (version == null) continue;
            return archive.resolveSnapshot(version);
        }
        return null;
    }

    public File toLocalFile(String path) {
        return IO.getFile(this.base, path);
    }

    @Override
    public File toLocalFile(Archive archive) {
        return this.toLocalFile(archive.localPath);
    }

    @Override
    public long getLastUpdated(Revision revision) throws Exception {
        if (revision.isSnapshot()) {
            File metafile = this.toLocalFile(revision.metadata(this.id));
            return metafile.lastModified();
        }
        File dir = this.toLocalFile(revision.path);
        return dir.lastModified();
    }

    @Override
    public Archive getArchive(String s) throws Exception {
        Matcher matcher = ARCHIVE_P.matcher(Strings.trim(s));
        if (!matcher.matches()) {
            return null;
        }
        String group = Strings.trim(matcher.group("group"));
        String artifact = Strings.trim(matcher.group("artifact"));
        String extension = Strings.trim(matcher.group("extension"));
        String classifier = Strings.trim(matcher.group("classifier"));
        String version = Strings.trim(matcher.group("version"));
        return Program.valueOf(group, artifact).version(version).archive(extension, classifier);
    }

    @Override
    public void close() throws IOException {
        for (MavenBackingRepository mbr : this.snapshot) {
            IO.close(mbr);
        }
        for (MavenBackingRepository mbr : this.release) {
            IO.close(mbr);
        }
    }

    @Override
    public URI toRemoteURI(Archive archive) throws Exception {
        return this.toLocalFile(archive).toURI();
    }

    public void store(Archive archive, InputStream in) throws IOException {
        File file = IO.getFile(this.base, archive.localPath);
        IO.copy(in, file);
    }

    @Override
    public boolean refresh() throws IOException {
        return false;
    }

    public String toString() {
        return "MavenRepository [base=" + this.base + ", id=" + this.id + ", release=" + this.release + ", snapshot=" + this.snapshot + ", localOnly=" + this.localOnly + "]";
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public POM getPom(InputStream pomFile) throws Exception {
        return new POM(this, pomFile);
    }

    @Override
    public POM getPom(Revision revision) throws Exception {
        if (revision == null) {
            return null;
        }
        return (POM)this.getPomPromise(revision).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Promise<POM> getPomPromise(final Revision revision) throws Exception {
        Deferred deferred;
        Map<Revision, Promise<POM>> map = this.poms;
        synchronized (map) {
            Promise<POM> promise = this.poms.get(revision);
            if (promise != null) {
                return promise;
            }
            deferred = new Deferred();
            this.poms.put(revision, (Promise<POM>)deferred.getPromise());
        }
        Archive pomArchive = revision.getPomArchive();
        deferred.resolveWith(this.get(pomArchive, false).map((Function)new Function<File, POM>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public POM apply(File pomFile) {
                if (pomFile == null) {
                    return null;
                }
                try (FileInputStream fin = new FileInputStream(pomFile);){
                    POM pOM = MavenRepository.this.getPom(fin);
                    return pOM;
                }
                catch (Exception e) {
                    MavenRepository.this.reporter.exception((Throwable)e, "Failed to parse pom %s from file %s", new Object[]{revision, pomFile});
                    return null;
                }
            }
        }));
        return deferred.getPromise();
    }

    @Override
    public List<MavenBackingRepository> getSnapshotRepositories() {
        return Collections.unmodifiableList(this.snapshot);
    }

    @Override
    public List<MavenBackingRepository> getReleaseRepositories() {
        return Collections.unmodifiableList(this.release);
    }

    @Override
    public boolean isLocalOnly() {
        return this.localOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Archive archive) throws Exception {
        File file = File.createTempFile("pom", ".xml");
        try {
            File result = this.getFile(archive.getPomArchive(), file);
            boolean bl = result != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IO.delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Revision revision) {
        Map<Revision, Promise<POM>> map = this.poms;
        synchronized (map) {
            this.poms.remove(revision);
        }
    }
}

