/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.SmartList;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class Callbacks {

    public static interface ConstantAffectionResolver {
        public Future<ConstantAffection> request(String var1, String var2, int var3, boolean var4, boolean var5);
    }

    public static class ConstantAffection {
        public static final ConstantAffection EMPTY = new ConstantAffection();
        private final boolean myKnown;
        private final Collection<File> myAffectedFiles;

        public ConstantAffection(Collection<File> affectedFiles) {
            this.myAffectedFiles = affectedFiles;
            this.myKnown = true;
        }

        public ConstantAffection() {
            this.myKnown = false;
            this.myAffectedFiles = null;
        }

        public boolean isKnown() {
            return this.myKnown;
        }

        public Collection<File> getAffectedFiles() {
            return this.myAffectedFiles;
        }

        public static ConstantAffection compose(Collection<ConstantAffection> affections) {
            if (affections.isEmpty()) {
                return EMPTY;
            }
            if (affections.size() == 1) {
                return affections.iterator().next();
            }
            for (ConstantAffection a : affections) {
                if (a.isKnown()) continue;
                return EMPTY;
            }
            SmartList affected = new SmartList();
            for (ConstantAffection affection : affections) {
                affected.addAll(affection.getAffectedFiles());
            }
            return new ConstantAffection((Collection<File>)affected);
        }
    }

    public static interface Backend {
        public void associate(String var1, String var2, ClassReader var3);

        public void associate(String var1, Collection<String> var2, ClassReader var3);

        public void registerImports(String var1, Collection<String> var2, Collection<String> var3);
    }
}

