/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.flex.build;

import com.intellij.CommonBundle;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

public abstract class CompilerMessageHandlerBase {
    private static final String ERROR_PREFIX = "Error: ";
    private static final Logger LOG = Logger.getInstance((String)CompilerMessageHandlerBase.class.getName());
    private final CompileContext myContext;
    private final boolean myAsc20;
    private final String myCompilerName;
    private boolean myCompilationFinished;
    private boolean myCompilationFailed;
    private boolean myCompilationCancelled;
    @Nullable
    private String myPreviousUnreportedInfoMessage;

    public CompilerMessageHandlerBase(CompileContext context, boolean asc20, String compilerName) {
        this.myContext = context;
        this.myAsc20 = asc20;
        this.myCompilerName = compilerName;
    }

    public final void registerCompilationFinished() {
        this.myCompilationFinished = true;
        this.reportPreviousInfoMessage();
    }

    public boolean isCompilationFailed() {
        LOG.assertTrue(this.myCompilationFinished, (Object)"compilationFinished() method not called yet");
        return this.myCompilationFailed;
    }

    public boolean isCompilationCancelled() {
        LOG.assertTrue(this.myCompilationFinished, (Object)"compilationFinished() method not called yet");
        return this.myCompilationCancelled;
    }

    protected abstract void onCancelled();

    public void handleText(String text) {
        for (String line : StringUtil.splitByLines((String)text)) {
            this.handleLine(line.trim());
        }
        this.checkCancelled();
    }

    private void handleLine(String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            this.reportPreviousInfoMessage();
            return;
        }
        if (text.equals("^")) {
            this.myPreviousUnreportedInfoMessage = null;
            return;
        }
        if ("command line".equals(text)) {
            this.reportPreviousInfoMessage();
            return;
        }
        if (text.startsWith("Exception in thread \"") || text.contains("Could not create the Java virtual machine")) {
            this.reportPreviousInfoMessage();
            this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, BuildMessage.Kind.ERROR, text));
            this.myCompilationFailed = true;
            return;
        }
        if (this.myAsc20) {
            if (text.startsWith("Warning: ") || text.startsWith(ERROR_PREFIX) || text.startsWith("Syntax error: ") || text.startsWith("Internal error: ")) {
                BuildMessage.Kind kind = text.startsWith("Warning: ") ? BuildMessage.Kind.WARNING : BuildMessage.Kind.ERROR;
                int index = text.indexOf(": ");
                String usefulMessage = text.substring(index + ": ".length());
                Pair<String, Integer> sourcePathAndLine = FlexCommonUtils.getSourcePathAndLineFromASC20Message(this.myPreviousUnreportedInfoMessage);
                if (sourcePathAndLine == null) {
                    this.reportPreviousInfoMessage();
                    this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, kind, usefulMessage));
                } else {
                    this.myPreviousUnreportedInfoMessage = null;
                    if (!CompilerMessageHandlerBase.isNotSupportedOptionFromGeneratedConfig(usefulMessage, (String)sourcePathAndLine.first)) {
                        this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, kind, usefulMessage, (String)sourcePathAndLine.first, -1L, -1L, -1L, (long)((Integer)sourcePathAndLine.second).intValue(), 0L));
                    }
                }
                this.myCompilationFailed |= kind == BuildMessage.Kind.ERROR;
                return;
            }
        } else {
            Matcher matcher = FlexCommonUtils.ERROR_PATTERN.matcher(text);
            if (matcher.matches()) {
                String sourceFilePath = matcher.group(1);
                String additionalInfo = matcher.group(2);
                String line = matcher.group(3);
                String column = matcher.group(4);
                String type = matcher.group(5);
                String message = matcher.group(6);
                BuildMessage.Kind kind = "Warning".equals(type) ? BuildMessage.Kind.WARNING : BuildMessage.Kind.ERROR;
                File file = new File(sourceFilePath);
                boolean sourceFileExists = file.exists();
                StringBuilder fullMessage = new StringBuilder();
                if (!sourceFileExists) {
                    fullMessage.append(sourceFilePath).append(": ");
                }
                if (additionalInfo != null) {
                    fullMessage.append(additionalInfo).append(' ');
                }
                fullMessage.append(message);
                this.reportPreviousInfoMessage();
                this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, kind, fullMessage.toString(), sourceFileExists ? sourceFilePath : null, -1L, -1L, -1L, line != null ? (long)Integer.parseInt(line) : 0L, column != null ? (long)Integer.parseInt(column) : 0L));
                this.myCompilationFailed |= kind == BuildMessage.Kind.ERROR;
                return;
            }
        }
        if (text.startsWith(ERROR_PREFIX)) {
            this.reportPreviousInfoMessage();
            this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, BuildMessage.Kind.ERROR, text.substring(ERROR_PREFIX.length())));
            this.myCompilationFailed = true;
            return;
        }
        this.reportPreviousInfoMessage();
        this.myPreviousUnreportedInfoMessage = text;
        if (text.contains("java.lang.OutOfMemoryError") || text.contains("Java heap space")) {
            this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, BuildMessage.Kind.ERROR, FlexCommonBundle.message("increase.flex.compiler.heap", CommonBundle.settingsActionPath())));
            this.myCompilationFailed = true;
        }
    }

    private static boolean isNotSupportedOptionFromGeneratedConfig(String message, String filePath) {
        String fileName = PathUtilRt.getFileName((String)filePath);
        return fileName.startsWith("idea-") && fileName.endsWith(".xml") && ("'compiler.locale' is not fully supported.".equals(message) || "'compiler.theme' is not fully supported.".equals(message) || "'compiler.preloader' is not fully supported.".equals(message) || "'compiler.accessible' is not fully supported.".equals(message) || "'compiler.fonts.managers' is not fully supported.".equals(message) || "'static-link-runtime-shared-libraries' is not fully supported.".equals(message));
    }

    private void reportPreviousInfoMessage() {
        if (this.myPreviousUnreportedInfoMessage != null) {
            if (!(this.myPreviousUnreportedInfoMessage.equals("<theme />") || this.myPreviousUnreportedInfoMessage.equals("</locale>") || this.myPreviousUnreportedInfoMessage.equals("<preloader>spark.preloaders.SplashScreen</preloader>") || this.myPreviousUnreportedInfoMessage.equals("<accessible>true</accessible>") || this.myPreviousUnreportedInfoMessage.equals("<accessible>false</accessible>") || this.myPreviousUnreportedInfoMessage.equals("</managers>") || this.myPreviousUnreportedInfoMessage.equals("<static-link-runtime-shared-libraries>false</static-link-runtime-shared-libraries>"))) {
                this.myContext.processMessage((BuildMessage)new CompilerMessage(this.myCompilerName, BuildMessage.Kind.INFO, this.myPreviousUnreportedInfoMessage));
            }
            this.myPreviousUnreportedInfoMessage = null;
        }
    }

    private void checkCancelled() {
        if (!this.myCompilationCancelled && this.myContext.getCancelStatus().isCanceled()) {
            this.myCompilationCancelled = true;
            this.onCancelled();
        }
    }
}

