/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsAndroidModuleExtensionImpl
extends JpsElementBase<JpsAndroidModuleExtensionImpl>
implements JpsAndroidModuleExtension {
    public static final JpsElementChildRoleBase<JpsAndroidModuleExtension> KIND = JpsElementChildRoleBase.create((String)"android extension");
    private final JpsAndroidModuleProperties myProperties;

    public JpsAndroidModuleExtensionImpl(JpsAndroidModuleProperties properties) {
        this.myProperties = properties;
    }

    @Override
    public JpsModule getModule() {
        return (JpsModule)this.getParent();
    }

    @NotNull
    public JpsAndroidModuleExtensionImpl createCopy() {
        JpsAndroidModuleExtensionImpl jpsAndroidModuleExtensionImpl = new JpsAndroidModuleExtensionImpl((JpsAndroidModuleProperties)XmlSerializerUtil.createCopy((Object)this.myProperties));
        if (jpsAndroidModuleExtensionImpl == null) {
            JpsAndroidModuleExtensionImpl.$$$reportNull$$$0(0);
        }
        return jpsAndroidModuleExtensionImpl;
    }

    public void applyChanges(@NotNull JpsAndroidModuleExtensionImpl modified) {
        if (modified == null) {
            JpsAndroidModuleExtensionImpl.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)modified.myProperties, (Object)this.myProperties);
        this.fireElementChanged();
    }

    @Override
    public String getCustomDebugKeyStorePath() {
        return JpsPathUtil.urlToPath((String)this.myProperties.CUSTOM_DEBUG_KEYSTORE_PATH);
    }

    @Override
    public List<AndroidNativeLibData> getAdditionalNativeLibs() {
        ArrayList<AndroidNativeLibData> libDatas = new ArrayList<AndroidNativeLibData>();
        for (JpsAndroidModuleProperties.AndroidNativeLibDataEntry nativeLib : this.myProperties.myNativeLibs) {
            if (nativeLib.myArchitecture == null || nativeLib.myUrl == null || nativeLib.myTargetFileName == null) continue;
            libDatas.add(new AndroidNativeLibData(nativeLib.myArchitecture, JpsPathUtil.urlToPath((String)nativeLib.myUrl), nativeLib.myTargetFileName));
        }
        return libDatas;
    }

    @Override
    public boolean isUseCustomManifestPackage() {
        return this.myProperties.USE_CUSTOM_MANIFEST_PACKAGE;
    }

    @Override
    public String getCustomManifestPackage() {
        return this.myProperties.CUSTOM_MANIFEST_PACKAGE;
    }

    @Override
    public String getAdditionalPackagingCommandLineParameters() {
        return this.myProperties.ADDITIONAL_PACKAGING_COMMAND_LINE_PARAMETERS;
    }

    @Override
    public boolean isManifestMergingEnabled() {
        return this.myProperties.ENABLE_MANIFEST_MERGING;
    }

    @Override
    public boolean isPreDexingEnabled() {
        return this.myProperties.ENABLE_PRE_DEXING;
    }

    @Override
    public boolean isMultiDexEnabled() {
        return this.myProperties.ENABLE_MULTI_DEX;
    }

    @Override
    public String getMainDexList() {
        return this.myProperties.MAIN_DEX_LIST;
    }

    @Override
    public boolean isMinimalMainDex() {
        return this.myProperties.MINIMAL_MAIN_DEX;
    }

    @Override
    public boolean isCopyCustomGeneratedSources() {
        return this.myProperties.COMPILE_CUSTOM_GENERATED_SOURCES;
    }

    @Override
    public File getResourceDir() {
        File resDir = this.findFileByRelativeModulePath(this.myProperties.RES_FOLDER_RELATIVE_PATH, false);
        return resDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(resDir) : null;
    }

    @Override
    @NotNull
    public List<File> getResourceOverlayDirs() {
        List<String> paths = this.myProperties.RES_OVERLAY_FOLDERS;
        if (paths == null || paths.isEmpty()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                JpsAndroidModuleExtensionImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull(paths, (Function)new Function<String, File>(){

            public File fun(String s) {
                File resDir = JpsAndroidModuleExtensionImpl.this.findFileByRelativeModulePath(s, false);
                return resDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(resDir) : null;
            }
        });
        if (list == null) {
            JpsAndroidModuleExtensionImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public File getResourceDirForCompilation() {
        File resDir = this.findFileByRelativeModulePath(this.myProperties.CUSTOM_APK_RESOURCE_FOLDER, false);
        return resDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(resDir) : null;
    }

    @Override
    public File getManifestFile() {
        File manifestFile = this.findFileByRelativeModulePath(this.myProperties.MANIFEST_FILE_RELATIVE_PATH, false);
        return manifestFile != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(manifestFile) : null;
    }

    @Override
    public File getManifestFileForCompilation() {
        File manifestFile = this.findFileByRelativeModulePath(this.myProperties.CUSTOM_COMPILER_MANIFEST, false);
        return manifestFile != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(manifestFile) : null;
    }

    @Override
    @Nullable
    public List<File> getProguardConfigFiles(@NotNull JpsModule module) throws IOException {
        JpsSdk sdk;
        if (module == null) {
            JpsAndroidModuleExtensionImpl.$$$reportNull$$$0(4);
        }
        String sdkHomePath = (sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE)) != null ? FileUtil.toSystemIndependentName((String)sdk.getHomePath()) : null;
        List<String> urls = this.myProperties.myProGuardCfgFiles;
        if (urls == null) {
            return null;
        }
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String url : urls) {
            if (sdkHomePath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomePath);
            }
            result.add(JpsPathUtil.urlToFile((String)url));
        }
        return result;
    }

    @Override
    public File getAssetsDir() {
        File manifestFile = this.findFileByRelativeModulePath(this.myProperties.ASSETS_FOLDER_RELATIVE_PATH, false);
        return manifestFile != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(manifestFile) : null;
    }

    @Override
    public File getAaptGenDir() throws IOException {
        File aaptGenDir = this.findFileByRelativeModulePath(this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT, true);
        return aaptGenDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(aaptGenDir) : null;
    }

    @Override
    public File getAidlGenDir() throws IOException {
        File aidlGenDir = this.findFileByRelativeModulePath(this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL, true);
        return aidlGenDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(aidlGenDir) : null;
    }

    public JpsAndroidModuleProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public File getNativeLibsDir() {
        File nativeLibsFolder = this.findFileByRelativeModulePath(this.myProperties.LIBS_FOLDER_RELATIVE_PATH, true);
        return nativeLibsFolder != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(nativeLibsFolder) : null;
    }

    @Override
    public File getProguardLogsDir() {
        File proguardLogsDir = this.findFileByRelativeModulePath(this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH, false);
        return proguardLogsDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(proguardLogsDir) : null;
    }

    private static File canonizeFilePath(@NotNull File file) {
        if (file == null) {
            JpsAndroidModuleExtensionImpl.$$$reportNull$$$0(5);
        }
        return new File(FileUtil.toCanonicalPath((String)file.getPath()));
    }

    @Nullable
    private File findFileByRelativeModulePath(String relativePath, boolean checkExistence) {
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        JpsModule module = this.getModule();
        File moduleBaseDir = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        if (moduleBaseDir != null) {
            String absPath = FileUtil.toSystemDependentName((String)(moduleBaseDir.getAbsolutePath() + relativePath));
            File f = new File(absPath);
            if (!checkExistence || f.exists()) {
                return f;
            }
        }
        return null;
    }

    @Override
    public boolean isGradleProject() {
        return !this.myProperties.ALLOW_USER_CONFIGURATION;
    }

    @Override
    public boolean isLibrary() {
        return this.myProperties.PROJECT_TYPE == 1;
    }

    @Override
    public boolean useCustomResFolderForCompilation() {
        return this.myProperties.USE_CUSTOM_APK_RESOURCE_FOLDER;
    }

    @Override
    public boolean useCustomManifestForCompilation() {
        return this.myProperties.USE_CUSTOM_COMPILER_MANIFEST;
    }

    @Override
    public boolean isPackTestCode() {
        return this.myProperties.PACK_TEST_CODE;
    }

    @Override
    public boolean isIncludeAssetsFromLibraries() {
        return this.myProperties.myIncludeAssetsFromLibraries;
    }

    @Override
    public boolean isRunProcessResourcesMavenTask() {
        return this.myProperties.RUN_PROCESS_RESOURCES_MAVEN_TASK;
    }

    @Override
    public boolean isRunProguard() {
        return this.myProperties.RUN_PROGUARD;
    }

    @Override
    public String getApkRelativePath() {
        return this.myProperties.APK_PATH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProguardConfigFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canonizeFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

