/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Colored;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtil {
    private ColorUtil() {
    }

    @NotNull
    public static Color marker(final @NotNull String name) {
        if (name == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        JBColor jBColor = new JBColor(new NotNullProducer<Color>(){

            @Override
            @NotNull
            public Color produce() {
                throw new AssertionError((Object)name);
            }
        }){

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public String toString() {
                return name;
            }
        };
        if (jBColor == null) {
            ColorUtil.$$$reportNull$$$0(1);
        }
        return jBColor;
    }

    public static Color softer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(2);
        }
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
    }

    public static Color darker(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(3);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float brightness = hsb[2];
        for (int i = 0; i < tones && (brightness = Math.max(0.0f, brightness / 1.1f)) != 0.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], hsb[1], brightness);
    }

    public static Color brighter(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(4);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float brightness = hsb[2];
        for (int i = 0; i < tones && (brightness = Math.min(1.0f, brightness * 1.1f)) != 1.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], hsb[1], brightness);
    }

    @NotNull
    public static Color saturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(5);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.min(1.0f, saturation * 1.1f)) != 1.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(6);
        }
        return color2;
    }

    @NotNull
    public static Color desaturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(7);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.max(0.0f, saturation / 1.1f)) != 0.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(8);
        }
        return color2;
    }

    public static Color dimmer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(9);
        }
        float[] rgb = color.getRGBColorComponents(null);
        float alpha = 0.8f;
        float rem = 1.0f - alpha;
        return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static Color shift(Color c, double d) {
        return new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
    }

    public static Color withAlpha(Color c, double a) {
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    public static Color srcOver(Color c, Color b) {
        float[] rgba = new float[4];
        float[] brgba = new float[4];
        rgba = c.getRGBComponents(rgba);
        brgba = b.getRGBComponents(brgba);
        float dsta = 1.0f - rgba[3];
        return new Color(rgba[0] * rgba[3] + dsta * brgba[0], rgba[1] * rgba[3] + dsta * brgba[1], rgba[2] * rgba[3] + dsta * brgba[2], 1.0f);
    }

    public static Color withPreAlpha(Color c, double a) {
        float[] rgba = new float[4];
        rgba = ColorUtil.withAlpha(c, a).getRGBComponents(rgba);
        return new Color(rgba[0] * rgba[3], rgba[1] * rgba[3], rgba[2] * rgba[3], 1.0f);
    }

    public static Color toAlpha(Color color, int a) {
        Color c = color != null ? color : Color.black;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static Color withAlphaAdjustingDarkness(Color c, double d) {
        return ColorUtil.shift(ColorUtil.withAlpha(c, d), d);
    }

    public static String toHex(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(10);
        }
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B = Integer.toHexString(c.getBlue());
        return (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B.length() < 2 ? "0" : "") + B;
    }

    public static Color fromHex(String str) {
        if ((str = StringUtil.trimStart(str, "#")).length() == 3) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16));
        }
        if (str.length() == 6) {
            return Color.decode("0x" + str);
        }
        throw new IllegalArgumentException("Should be String of 3 or 6 chars length.");
    }

    @Nullable
    public static Color fromHex(String str, @Nullable Color defaultValue) {
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Nullable
    public static Color getColor(@NotNull Class<?> cls) {
        Colored annotation;
        if (cls == null) {
            ColorUtil.$$$reportNull$$$0(11);
        }
        if ((annotation = cls.getAnnotation(Colored.class)) instanceof Colored) {
            Colored colored = annotation;
            return ColorUtil.fromHex(UIUtil.isUnderDarcula() ? colored.darkVariant() : colored.color(), null);
        }
        return null;
    }

    public static boolean isDark(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(12);
        }
        return 1.0 - (0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue()) / 255.0 >= 0.5;
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(13);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(14);
        }
        balance = Math.min(1.0, Math.max(0.0, balance));
        Color color = new Color((int)((1.0 - balance) * (double)c1.getRed() + (double)c2.getRed() * balance + 0.5), (int)((1.0 - balance) * (double)c1.getGreen() + (double)c2.getGreen() * balance + 0.5), (int)((1.0 - balance) * (double)c1.getBlue() + (double)c2.getBlue() * balance + 0.5), (int)((1.0 - balance) * (double)c1.getAlpha() + (double)c2.getAlpha() * balance + 0.5));
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(15);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "marker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "saturate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "marker";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "softer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saturate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dimmer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toHex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDark";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

