/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            ConcurrencyUtil.$$$reportNull$$$0(0);
        }
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future2 = executorService.submit(callable);
                futures.add(future2);
            }
            for (Future future : futures) {
                ((Runnable)((Object)future)).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException future2) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map == null) {
            ConcurrencyUtil.$$$reportNull$$$0(1);
        }
        if (key == null) {
            ConcurrencyUtil.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(3);
        }
        if ((v = map.get(key)) != null) {
            Object v2 = v;
            if (v2 == null) {
                ConcurrencyUtil.$$$reportNull$$$0(4);
            }
            return v2;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(5);
        }
        return v3;
    }

    @NotNull
    public static <T> T cacheOrGet(@NotNull AtomicReference<T> ref, @NotNull T defaultValue) {
        if (ref == null) {
            ConcurrencyUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(7);
        }
        T value = ref.get();
        while (value == null) {
            value = ref.compareAndSet(null, defaultValue) ? defaultValue : ref.get();
        }
        T t = value;
        if (t == null) {
            ConcurrencyUtil.$$$reportNull$$$0(8);
        }
        return t;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String name) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(9);
        }
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor(name, 5);
        if (threadPoolExecutor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(10);
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String name, int priority) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(11);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
        if (threadPoolExecutor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(12);
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NotNull @NonNls String name) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(13);
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor(name, 5);
        if (scheduledThreadPoolExecutor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(14);
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String name, int priority) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(15);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(16);
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String name, final boolean isDaemon, final int priority) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(17);
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    1.$$$reportNull$$$0(0);
                }
                Thread thread = new Thread(r, name);
                thread.setDaemon(isDaemon);
                thread.setPriority(priority);
                Thread thread2 = thread;
                if (thread2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return thread2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "r";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ConcurrencyUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ConcurrencyUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "newThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "newThread";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (threadFactory == null) {
            ConcurrencyUtil.$$$reportNull$$$0(18);
        }
        return threadFactory;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String name) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(19);
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    2.$$$reportNull$$$0(0);
                }
                Thread thread = new Thread(r, name);
                if (thread == null) {
                    2.$$$reportNull$$$0(1);
                }
                return thread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "r";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ConcurrencyUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ConcurrencyUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "newThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "newThread";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (threadFactory == null) {
            ConcurrencyUtil.$$$reportNull$$$0(20);
        }
        return threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void awaitQuiescence(@NotNull ThreadPoolExecutor executor, long timeout, @NotNull TimeUnit timeUnit) {
        HashSet workers;
        if (executor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(21);
        }
        if (timeUnit == null) {
            ConcurrencyUtil.$$$reportNull$$$0(22);
        }
        executor.setKeepAliveTime(1L, TimeUnit.NANOSECONDS);
        executor.setCorePoolSize(0);
        ReentrantLock mainLock = ReflectionUtil.getField(executor.getClass(), executor, ReentrantLock.class, "mainLock");
        mainLock.lock();
        try {
            HashSet workersField = ReflectionUtil.getField(executor.getClass(), executor, HashSet.class, "workers");
            workers = new HashSet(workersField);
        }
        finally {
            mainLock.unlock();
        }
        for (Object worker : workers) {
            void unit;
            Thread thread = ReflectionUtil.getField(worker.getClass(), worker, Thread.class, "thread");
            try {
                thread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                System.err.println("Executor " + executor + " is still active after " + unit.toSeconds(timeout) + " seconds://///\nThread " + thread + " dump:\n" + trace + "all thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n/////");
                break;
            }
        }
    }

    public static void joinAll(@NotNull Collection<? extends Thread> threads) throws RuntimeException {
        if (threads == null) {
            ConcurrencyUtil.$$$reportNull$$$0(23);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void joinAll(Thread ... threads) throws RuntimeException {
        if (threads == null) {
            ConcurrencyUtil.$$$reportNull$$$0(24);
        }
        ConcurrencyUtil.joinAll(Arrays.asList(threads));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderThreadName(@NotNull String name, @NotNull Runnable runnable) {
        Thread currentThread;
        String oldThreadName;
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(25);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(26);
        }
        if (name.equals(oldThreadName = (currentThread = Thread.currentThread()).getName())) {
            runnable.run();
        } else {
            currentThread.setName(name);
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(oldThreadName);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newSingleThreadExecutor";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newNamedThreadFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newSingleThreadExecutor";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newNamedThreadFactory";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescence";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "joinAll";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runUnderThreadName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

