/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangExtensionService;
import org.jetbrains.jps.intellilang.model.impl.JpsIntelliLangConfigurationImpl;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;

public class JpsIntelliLangConfigurationSerializer
extends JpsGlobalExtensionSerializer {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.intellilang.model.impl.JpsIntelliLangConfigurationSerializer");
    private static final String INSTRUMENTATION_TYPE_NAME = "INSTRUMENTATION";
    private static final String PATTERN_ANNOTATION_NAME = "PATTERN_ANNOTATION";

    public JpsIntelliLangConfigurationSerializer() {
        super("IntelliLang.xml", "LanguageInjectionConfiguration");
    }

    public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
        String instrumentationType;
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/intellilang/model/impl/JpsIntelliLangConfigurationSerializer", "loadExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/intellilang/model/impl/JpsIntelliLangConfigurationSerializer", "loadExtension"));
        }
        JpsIntelliLangConfigurationImpl configuration = new JpsIntelliLangConfigurationImpl();
        String annotationName = JDOMExternalizerUtil.readField((Element)componentTag, (String)PATTERN_ANNOTATION_NAME);
        if (annotationName != null) {
            configuration.setPatternAnnotationClassName(annotationName);
        }
        if ((instrumentationType = JDOMExternalizerUtil.readField((Element)componentTag, (String)INSTRUMENTATION_TYPE_NAME)) != null) {
            try {
                InstrumentationType type = InstrumentationType.valueOf(instrumentationType);
                configuration.setInstrumentationType(type);
            }
            catch (IllegalArgumentException ignored) {
                LOG.info((Throwable)ignored);
            }
        }
        JpsIntelliLangExtensionService.getInstance().setConfiguration(global, configuration);
    }

    public void loadExtensionWithDefaultSettings(@NotNull JpsGlobal global) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/intellilang/model/impl/JpsIntelliLangConfigurationSerializer", "loadExtensionWithDefaultSettings"));
        }
        JpsIntelliLangExtensionService.getInstance().setConfiguration(global, new JpsIntelliLangConfigurationImpl());
    }

    public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/intellilang/model/impl/JpsIntelliLangConfigurationSerializer", "saveExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/intellilang/model/impl/JpsIntelliLangConfigurationSerializer", "saveExtension"));
        }
    }
}

