/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsCompilerExcludesImpl
implements JpsCompilerExcludes {
    private final Set<File> myFiles = new HashSet<File>();
    private final Set<File> myDirectories = new HashSet<File>();
    private final Set<File> myRecursivelyExcludedDirectories = new HashSet<File>();

    @Override
    public void addExcludedFile(String url) {
        this.addExcludedFile(JpsPathUtil.urlToFile(url));
    }

    @Override
    public void addExcludedDirectory(String url, boolean recursively) {
        this.addExcludedDirectory(JpsPathUtil.urlToFile(url), recursively);
    }

    protected void addExcludedFile(File file) {
        this.myFiles.add(file);
    }

    protected void addExcludedDirectory(File dir, boolean recursively) {
        (recursively ? this.myRecursivelyExcludedDirectories : this.myDirectories).add(dir);
    }

    @Override
    public boolean isExcluded(File file) {
        if (this.myFiles.contains(file)) {
            return true;
        }
        if (!this.myDirectories.isEmpty() || !this.myRecursivelyExcludedDirectories.isEmpty()) {
            File parent = FileUtilRt.getParentFile((File)file);
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            while (parent != null) {
                if (this.myRecursivelyExcludedDirectories.contains(parent)) {
                    return true;
                }
                parent = FileUtilRt.getParentFile((File)parent);
            }
        }
        return false;
    }
}

