/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidAptValidityState;
import org.jetbrains.jps.android.AndroidJpsProjectUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class AndroidAptStateStorage
extends AbstractStateStorage<String, AndroidAptValidityState> {
    public static final StorageProvider<AndroidAptStateStorage> PROVIDER = new StorageProvider<AndroidAptStateStorage>(){

        @NotNull
        public AndroidAptStateStorage createStorage(File targetDataDir) throws IOException {
            AndroidAptStateStorage androidAptStateStorage = new AndroidAptStateStorage(targetDataDir);
            if (androidAptStateStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidAptStateStorage$1", "createStorage"));
            }
            return androidAptStateStorage;
        }
    };
    @NonNls
    private static final String RESOURCE_NAMES_STORAGE = "resource_names";

    private AndroidAptStateStorage(@NotNull File dataStorageRoot) throws IOException {
        if (dataStorageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStorageRoot", "org/jetbrains/jps/android/AndroidAptStateStorage", "<init>"));
        }
        super(AndroidJpsProjectUtil.getStorageFile(dataStorageRoot, RESOURCE_NAMES_STORAGE), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
    }

    private static class MyDataExternalizer
    implements DataExternalizer<AndroidAptValidityState> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, AndroidAptValidityState value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/android/AndroidAptStateStorage$MyDataExternalizer", "save"));
            }
            value.save(out);
        }

        public AndroidAptValidityState read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/android/AndroidAptStateStorage$MyDataExternalizer", "read"));
            }
            return new AndroidAptValidityState(in);
        }
    }
}

