/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.propertysubstitution;

import com.springsource.bundlor.support.propertysubstitution.IdentityTransformer;
import com.springsource.bundlor.support.propertysubstitution.ReplacementTransformer;
import com.springsource.bundlor.support.propertysubstitution.SumTransformer;
import com.springsource.bundlor.support.propertysubstitution.Token;
import com.springsource.bundlor.support.propertysubstitution.Transformer;
import com.springsource.bundlor.support.propertysubstitution.VersionExpander;
import com.springsource.bundlor.support.propertysubstitution.VersionExpansionFormatException;
import java.util.ArrayList;
import java.util.List;

final class VersionExpansionParser {
    private final String expansionString;
    private char[] data;
    private int dataLength;
    private int pos;
    private List<Token> tokens = new ArrayList<Token>();
    private int currentTokenPointer;
    private int tokenCount;
    private boolean startInclusive;
    private boolean endInclusive;
    private int currentVersionComponent = 0;
    private boolean devouringLowerLimit;
    private List<Transformer> lowerVersionTransformers = new ArrayList<Transformer>();
    private List<Transformer> upperVersionTransformers = new ArrayList<Transformer>();

    private VersionExpansionParser(String expansion) {
        this.expansionString = expansion;
    }

    public static VersionExpander parseVersionExpander(String expansion) throws VersionExpansionFormatException {
        return new VersionExpansionParser(expansion).parseExpansion();
    }

    private VersionExpander parseExpansion() throws VersionExpansionFormatException {
        if (!this.expansionString.contains(",")) {
            throw new VersionExpansionFormatException(this.expansionString, "missing comma in input data '" + this.expansionString + "'");
        }
        this.data = (String.valueOf(this.expansionString) + "\u0000").toCharArray();
        this.dataLength = this.data.length;
        this.pos = 0;
        this.lex();
        this.parse();
        return new VersionExpander(this.startInclusive, this.lowerVersionTransformers, this.upperVersionTransformers, this.endInclusive);
    }

    private void parse() {
        this.tokenCount = this.tokens.size();
        this.currentTokenPointer = 0;
        this.eatRangeStart();
        this.devouringLowerLimit = true;
        this.currentVersionComponent = 0;
        do {
            this.eatModifier();
        } while (this.maybeEatDot());
        this.eatComma();
        this.devouringLowerLimit = false;
        this.currentVersionComponent = 0;
        do {
            this.eatModifier();
        } while (this.maybeEatDot());
        this.eatRangeEnd();
    }

    private void eatRangeStart() {
        Token token = this.tokens.get(this.currentTokenPointer++);
        if (token.kind == Token.TokenKind.STARTINCLUSIVE) {
            this.startInclusive = true;
        } else if (token.kind == Token.TokenKind.STARTEXCLUSIVE) {
            this.startInclusive = false;
        } else {
            this.raiseParseProblem("expected a version start character '[' or '(' but found '" + this.string(token) + "' at position " + token.start, token.start);
        }
    }

    private String string(Token t) {
        return this.expansionString.substring(t.start, t.end);
    }

    private void eatRangeEnd() {
        Token token = this.tokens.get(this.currentTokenPointer++);
        if (token.kind == Token.TokenKind.ENDINCLUSIVE) {
            this.endInclusive = true;
        } else if (token.kind == Token.TokenKind.ENDEXCLUSIVE) {
            this.endInclusive = false;
        } else {
            this.raiseParseProblem("expected a version end character ']' or ')' but found '" + this.string(token) + "' at position " + token.start, token.start);
        }
    }

    private void pushIt(Transformer transformer) {
        if (this.devouringLowerLimit) {
            this.lowerVersionTransformers.add(transformer);
        } else {
            this.upperVersionTransformers.add(transformer);
        }
        ++this.currentVersionComponent;
    }

    private void processEquals() {
        this.pushIt(IdentityTransformer.instance);
    }

    private void processNumericModifier() {
        Token token = this.tokens.get(this.currentTokenPointer);
        if (this.currentVersionComponent == 3) {
            this.raiseParseProblem("cannot specify a numerical +/- value for the qualifier, found '" + this.string(token) + "' at position " + token.start, token.start);
        }
        String tokenString = this.string(token);
        try {
            Integer value = null;
            value = token.kind == Token.TokenKind.PLUSNUMBER ? Integer.valueOf(Integer.parseInt(tokenString.substring(1))) : Integer.valueOf(Integer.parseInt(tokenString));
            this.pushIt(new SumTransformer(value));
        }
        catch (NumberFormatException numberFormatException) {
            this.raiseParseProblem("cannot parse numerical value '" + tokenString + "' at position " + token.start, token.start);
        }
    }

    private void processPossibleNumber(String data, int position) {
        Token t = this.tokens.get(this.currentTokenPointer);
        try {
            char possiblePlus = data.charAt(position);
            Integer value = null;
            if (possiblePlus == '+') {
                String number = data.substring(position + 1);
                if (number.length() > 0 && number.charAt(0) == '-') {
                    this.raiseParseProblem("numeric modifier for macro should be +nnn or -nnn.  This '" + data + " is not allowed, at position " + t.start, t.start);
                }
                value = Integer.parseInt(data.substring(position + 1));
            } else {
                if (possiblePlus != '-') {
                    this.raiseParseProblem("numeric modifier for macro should be +nnn or -nnn.  This '" + data + " is not allowed, at position " + t.start, t.start);
                }
                value = Integer.parseInt(data.substring(position));
            }
            this.pushIt(new SumTransformer(value));
        }
        catch (NumberFormatException numberFormatException) {
            this.raiseParseProblem("unable to determine the numeric modifier for macro.  Macro was '" + data + "' at position " + t.start, t.start);
        }
    }

    private void processWord() {
        Token token = this.tokens.get(this.currentTokenPointer);
        String tokenString = this.string(token);
        if (tokenString.startsWith("maj")) {
            if (tokenString.length() == 3) {
                this.pushIt(IdentityTransformer.instance);
            } else {
                this.processPossibleNumber(tokenString, 3);
            }
            this.pushIt(new ReplacementTransformer("0"));
            this.pushIt(new ReplacementTransformer("0"));
        } else if (tokenString.startsWith("min")) {
            this.pushIt(IdentityTransformer.instance);
            if (tokenString.length() == 3) {
                this.pushIt(IdentityTransformer.instance);
            } else {
                this.processPossibleNumber(tokenString, 3);
            }
            this.pushIt(new ReplacementTransformer("0"));
        } else if (tokenString.startsWith("mic")) {
            this.pushIt(IdentityTransformer.instance);
            this.pushIt(IdentityTransformer.instance);
            if (tokenString.length() == 3) {
                this.pushIt(IdentityTransformer.instance);
            } else {
                this.processPossibleNumber(tokenString, 3);
            }
        } else if (tokenString.equals("qual")) {
            this.pushIt(IdentityTransformer.instance);
            this.pushIt(IdentityTransformer.instance);
            this.pushIt(IdentityTransformer.instance);
            this.pushIt(IdentityTransformer.instance);
        } else {
            if (this.currentVersionComponent < 3) {
                this.raiseParseProblem("expected one of: '=' '+nnn' '-nnn' or 'nnn' but found '" + this.string(token) + "' at position " + token.start, token.start);
            }
            this.pushIt(new ReplacementTransformer(tokenString));
        }
    }

    private void processNumeric() {
        Token token = this.tokens.get(this.currentTokenPointer);
        String tokenString = this.string(token);
        this.pushIt(new ReplacementTransformer(tokenString));
    }

    private void eatModifier() {
        if (this.currentTokenPointer >= this.tokenCount) {
            this.raiseParseProblem("run out of tokens to process", this.expansionString.length());
        }
        Token token = this.tokens.get(this.currentTokenPointer);
        Token.TokenKind k = token.kind;
        if (this.currentVersionComponent > 3) {
            this.raiseParseProblem("too many version components specified, only major.minor.micro.qualifier is allowed.  Found '" + this.string(token) + "' at position " + token.start, token.start);
        }
        if (k == Token.TokenKind.EQUALS) {
            this.processEquals();
        } else if (k == Token.TokenKind.WORD) {
            this.processWord();
        } else if (k == Token.TokenKind.NUMBER) {
            this.processNumeric();
        } else if (k == Token.TokenKind.PLUSNUMBER || k == Token.TokenKind.NEGATIVENUMBER) {
            this.processNumericModifier();
        } else if (this.currentVersionComponent < 3) {
            this.raiseParseProblem("expected one of: '=' '+nnn' '-nnn' or 'nnn' but found '" + this.string(token) + "' at position " + token.start, token.start);
        } else {
            this.raiseParseProblem("expected one of: '=' '+nnn' '-nnn' 'nnn' or 'xxx' but found '" + this.string(token) + "' at position " + token.start, token.start);
        }
        ++this.currentTokenPointer;
    }

    private void eatComma() {
        Token token = this.tokens.get(this.currentTokenPointer);
        if (token.kind == Token.TokenKind.COMMA) {
            ++this.currentTokenPointer;
        } else {
            this.raiseParseProblem("expected a comma but found " + this.string(token) + " at position " + token.start, token.start);
        }
    }

    private boolean maybeEatDot() {
        if (this.currentTokenPointer >= this.tokenCount) {
            this.raiseParseProblem("run out of tokens to process whilst expecting '.'", this.expansionString.length());
        }
        Token token = this.tokens.get(this.currentTokenPointer);
        if (token.kind == Token.TokenKind.DOT) {
            ++this.currentTokenPointer;
            return true;
        }
        return false;
    }

    private void lex() {
        while (this.pos < this.dataLength) {
            char ch = this.data[this.pos];
            if (this.isDigit(ch)) {
                this.lexNumber();
                continue;
            }
            if (this.isComma(ch)) {
                this.lexComma();
                continue;
            }
            if (this.isRangeDelimiter(ch)) {
                this.lexRangeDelimiter();
                continue;
            }
            if (this.isDot(ch)) {
                this.lexDot();
                continue;
            }
            if (this.isEquals(ch)) {
                this.lexEquals();
                continue;
            }
            if (this.isPlus(ch)) {
                this.lexPositiveNumber();
                continue;
            }
            if (this.isMinus(ch)) {
                this.lexNegativeNumber();
                continue;
            }
            if (this.isSpace(ch)) {
                ++this.pos;
                continue;
            }
            if (ch == '\u0000') break;
            this.lexWord();
        }
    }

    private boolean isRangeDelimiter(char ch) {
        return "[]()".indexOf(ch) != -1;
    }

    private void lexRangeDelimiter() {
        switch (this.data[this.pos]) {
            case '[': {
                this.tokens.add(new Token(Token.TokenKind.STARTINCLUSIVE, this.pos, this.pos));
                break;
            }
            case ']': {
                this.tokens.add(new Token(Token.TokenKind.ENDINCLUSIVE, this.pos, this.pos));
                break;
            }
            case '(': {
                this.tokens.add(new Token(Token.TokenKind.STARTEXCLUSIVE, this.pos, this.pos));
                break;
            }
            case ')': {
                this.tokens.add(new Token(Token.TokenKind.ENDEXCLUSIVE, this.pos, this.pos));
            }
        }
        ++this.pos;
    }

    private void lexWord() {
        int qualifierStart = this.pos;
        char ch = '\u0000';
        while (!(this.isSpace(ch = this.data[++this.pos]) || this.isDot(ch) || this.isComma(ch) || this.isRangeDelimiter(ch) || ch == '\u0000' || this.pos >= this.data.length)) {
        }
        this.tokens.add(new Token(Token.TokenKind.WORD, qualifierStart, this.pos));
    }

    private void lexNumber() {
        int numberStart = this.pos;
        this.readDigits();
        this.tokens.add(new Token(Token.TokenKind.NUMBER, numberStart, this.pos));
    }

    private void lexPositiveNumber() {
        int numberStart = this.pos;
        this.readDigits();
        this.tokens.add(new Token(Token.TokenKind.PLUSNUMBER, numberStart, this.pos));
    }

    private void lexNegativeNumber() {
        int numberStart = this.pos;
        this.readDigits();
        this.tokens.add(new Token(Token.TokenKind.NEGATIVENUMBER, numberStart, this.pos));
    }

    private void readDigits() {
        while (this.isDigit(this.data[++this.pos])) {
        }
    }

    private void lexDot() {
        this.tokens.add(new Token(Token.TokenKind.DOT, this.pos, ++this.pos));
    }

    private void lexEquals() {
        this.tokens.add(new Token(Token.TokenKind.EQUALS, this.pos, ++this.pos));
    }

    private void lexComma() {
        this.tokens.add(new Token(Token.TokenKind.COMMA, this.pos, ++this.pos));
    }

    private boolean isSpace(char ch) {
        return ch == ' ';
    }

    private boolean isEquals(char ch) {
        return ch == '=';
    }

    private boolean isPlus(char ch) {
        return ch == '+';
    }

    private boolean isMinus(char ch) {
        return ch == '-';
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isDot(char ch) {
        return ch == '.';
    }

    private boolean isComma(char ch) {
        return ch == ',';
    }

    private void raiseParseProblem(String message, int position) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.expansionString).append("\n");
        int i = 0;
        while (i < position) {
            sb.append(" ");
            ++i;
        }
        sb.append("^\n");
        sb.append(message);
        throw new VersionExpansionFormatException(this.expansionString, sb.toString());
    }
}

