/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtSdkPathUtil {
    @NonNls
    public static final String GWT_DEV_JAR = "gwt-dev.jar";
    @NonNls
    private static final String GWT_DEV_WINDOWS_JAR = "gwt-dev-windows.jar";
    @NonNls
    private static final String GWT_DEV_LINUX_JAR = "gwt-dev-linux.jar";
    @NonNls
    private static final String GWT_DEV_MAC_JAR = "gwt-dev-mac.jar";
    public static final String[][] ADDITIONAL_2_7_DEPENDENCIES = new String[][]{{"org.ow2.asm", "asm", "5.0.3"}, {"org.ow2.asm", "asm-util", "5.0.3"}, {"org.ow2.asm", "asm-tree", "5.0.3"}, {"org.ow2.asm", "asm-commons", "5.0.3"}};
    public static final String[][] ADDITIONAL_2_8_DEPENDENCIES = new String[][]{{"com.google.jsinterop", "jsinterop-annotations", "1.0.0"}, {"javax.servlet", "javax.servlet-api", "3.1.0"}, {"org.w3c.css", "sac", "1.3"}, {"com.google.code.gson", "gson", "2.6.2"}, {"colt", "colt", "1.2.0"}, {"ant", "ant", "1.6.5"}, {"commons-collections", "commons-collections", "3.2.2"}, {"commons-io", "commons-io", "2.4"}, {"com.ibm.icu", "icu4j", "50.1.1"}, {"tapestry", "tapestry", "4.0.2"}, {"net.sourceforge.htmlunit", "htmlunit", "2.19"}, {"xalan", "xalan", "2.7.2"}, {"xalan", "serializer", "2.7.2"}, {"xml-apis", "xml-apis", "1.4.01"}, {"org.apache.commons", "commons-lang3", "3.4"}, {"org.apache.httpcomponents", "httpclient", "4.5.1"}, {"org.apache.httpcomponents", "httpcore", "4.4.3"}, {"commons-logging", "commons-logging", "1.2"}, {"commons-codec", "commons-codec", "1.10"}, {"org.apache.httpcomponents", "httpmime", "4.5.1"}, {"net.sourceforge.htmlunit", "htmlunit-core-js", "2.17"}, {"xerces", "xercesImpl", "2.11.0"}, {"net.sourceforge.nekohtml", "nekohtml", "1.9.22"}, {"net.sourceforge.cssparser", "cssparser", "0.9.18"}, {"org.eclipse.jetty.websocket", "websocket-client", "9.2.13.v20150730"}, {"org.eclipse.jetty", "jetty-util", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-io", "9.2.14.v20151106"}, {"org.eclipse.jetty.websocket", "websocket-common", "9.2.13.v20150730"}, {"org.eclipse.jetty.websocket", "websocket-api", "9.2.13.v20150730"}, {"org.eclipse.jetty", "jetty-webapp", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-xml", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-servlet", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-security", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-server", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-http", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-servlets", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-continuation", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-annotations", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-plus", "9.2.14.v20151106"}, {"org.eclipse.jetty", "jetty-jndi", "9.2.14.v20151106"}, {"javax.annotation", "javax.annotation-api", "1.2"}, {"org.eclipse.jetty", "apache-jsp", "9.2.14.v20151106"}, {"org.eclipse.jetty.toolchain", "jetty-schemas", "3.1.M0"}, {"org.mortbay.jasper", "apache-jsp", "8.0.9.M3"}, {"org.mortbay.jasper", "apache-el", "8.0.9.M3"}};

    @NotNull
    public static List<String> findValidationJars(File parent) {
        File[] files = parent.listFiles();
        ArrayList<String> paths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith("validation-api-") || !name.endsWith(".jar")) continue;
                paths.add(file.getAbsolutePath());
            }
        }
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtSdkPathUtil", "findValidationJars"));
        }
        return arrayList;
    }

    public static String getCodeServerJarPath(String homePath) {
        return homePath + File.separator + "gwt-codeserver.jar";
    }

    public static String getUserJarPath(String homePath) {
        return homePath + File.separator + "gwt-user.jar";
    }

    public static String getSystemDependentDevJarName() {
        String jarName = SystemInfo.isWindows ? GWT_DEV_WINDOWS_JAR : (SystemInfo.isMac ? GWT_DEV_MAC_JAR : GWT_DEV_LINUX_JAR);
        return jarName;
    }

    public static String getDevJarPath(String homePath) {
        String newPath = GwtSdkPathUtil.getSystemIndependentDevJarPath(homePath);
        if (new File(newPath).exists()) {
            return newPath;
        }
        String oldPath = GwtSdkPathUtil.getSystemDependentDevJarPath(homePath);
        if (new File(oldPath).exists()) {
            return oldPath;
        }
        return newPath;
    }

    public static String getSystemIndependentDevJarPath(String homePath) {
        return homePath + File.separator + GWT_DEV_JAR;
    }

    public static String getSystemDependentDevJarPath(String homePath) {
        return homePath + File.separator + GwtSdkPathUtil.getSystemDependentDevJarName();
    }

    public static List<String> findValidationJarsInMavenRepo(String repositoryPath) {
        File validationDir = new File(FileUtil.toSystemDependentName((String)(repositoryPath + "/javax/validation/validation-api")));
        String[] fileNames = validationDir.list();
        if (fileNames != null && fileNames.length > 0) {
            String version = Collections.max(Arrays.asList(fileNames), VersionComparatorUtil.COMPARATOR);
            return GwtSdkPathUtil.findValidationJars(new File(validationDir, version));
        }
        return Collections.emptyList();
    }
}

