/*
 * Decompiled with CFR 0.152.
 */
package aQute.service.library;

import aQute.bnd.version.Version;
import aQute.service.library.Library;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibraryVersion
implements Comparable<LibraryVersion> {
    final long major;
    final long minor;
    final long micro;
    final String qualifier;
    final String input;
    static Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
    static Pattern fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);
    static Pattern nummeric = Pattern.compile("\\d*");

    public LibraryVersion(String baseline, String qualifier) {
        this(qualifier == null ? baseline : String.valueOf(baseline) + "." + LibraryVersion.cleanupModifier(qualifier));
    }

    public LibraryVersion(Library.RevisionRef ref) {
        this(ref.version);
    }

    public LibraryVersion(Library.Revision revision) {
        this(revision.version);
    }

    public LibraryVersion(String version) {
        Matcher m;
        this.input = version;
        if (version.trim().isEmpty()) {
            version = "0";
        }
        if (!(m = fuzzyVersion.matcher(version)).matches() && !(m = fuzzyVersion.matcher("0.0.0." + LibraryVersion.cleanupModifier(version))).matches()) {
            throw new IllegalArgumentException("Really screwed up version " + version);
        }
        String major = LibraryVersion.removeLeadingZeroes(m.group(1));
        String minor = LibraryVersion.removeLeadingZeroes(m.group(3));
        String micro = LibraryVersion.removeLeadingZeroes(m.group(5));
        String qualifier = m.group(7);
        if (qualifier == null) {
            if (!LibraryVersion.isInteger(minor)) {
                qualifier = minor;
                minor = "0";
                micro = "0";
            } else if (!LibraryVersion.isInteger(micro)) {
                qualifier = micro;
                micro = "0";
            }
        }
        this.major = this.toLong(major);
        this.minor = this.toLong(minor);
        this.micro = this.toLong(micro);
        this.qualifier = LibraryVersion.cleanupModifier(qualifier);
    }

    private long toLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static boolean isValid(String version) {
        Matcher m = fuzzyVersion.matcher(version);
        return m.matches();
    }

    public String toString() {
        return this.input;
    }

    public String getBaseline() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toOSGi() {
        if (this.qualifier != null) {
            return String.valueOf(this.getBaseline()) + "." + this.qualifier;
        }
        return this.getBaseline();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LibraryVersion)) {
            return false;
        }
        return this.compareTo((LibraryVersion)other) == 0;
    }

    public int hashCode() {
        return (int)(this.major * 97L ^ this.minor * 13L ^ this.micro + (long)(this.qualifier == null ? 97 : this.qualifier.hashCode()));
    }

    @Override
    public int compareTo(LibraryVersion other) {
        if (other == this) {
            return 0;
        }
        LibraryVersion o = other;
        if (this.major != o.major) {
            return this.major > o.major ? 1 : -1;
        }
        if (this.minor != o.minor) {
            return this.minor > o.minor ? 1 : -1;
        }
        if (this.micro != o.micro) {
            return this.micro > o.micro ? 1 : -1;
        }
        int c = 0;
        if (this.qualifier != null) {
            c = 1;
        }
        if (o.qualifier != null) {
            c += 2;
        }
        switch (c) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return -1;
            }
        }
        return this.qualifier.compareTo(o.qualifier);
    }

    private static boolean isInteger(String minor) {
        return minor.length() < 10 || minor.length() == 10 && minor.compareTo("2147483647") < 0;
    }

    private static String removeLeadingZeroes(String group) {
        if (group == null) {
            return "0";
        }
        int n = 0;
        while (n < group.length() - 1 && group.charAt(n) == '0') {
            ++n;
        }
        if (n == 0) {
            return group;
        }
        return group.substring(n);
    }

    static String cleanupModifier(String modifier) {
        if (modifier == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < modifier.length()) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public Object getWithoutQualifier() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.micro;
    }

    public Version getVersion() {
        return new Version((int)this.major, (int)this.minor, (int)this.micro, this.qualifier);
    }
}

