/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.p2.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.BridgeRepository;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceGenerator;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.util.repository.DownloadListenerPromise;
import aQute.bnd.version.Version;
import aQute.p2.api.Artifact;
import aQute.p2.provider.P2Impl;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.osgi.util.function.Function;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;

class P2Indexer
implements Closeable {
    private static final long MAX_STALE = TimeUnit.DAYS.toMillis(100L);
    private final Reporter reporter;
    final File location;
    private final HttpClient client;
    private final URI url;
    private final String name;
    private final File indexFile;
    private volatile BridgeRepository bridge;
    private static final Resource RECOVERY = new ResourceBuilder().build();

    P2Indexer(Reporter reporter, File location, HttpClient client, URI url, String name) throws Exception {
        Repository r;
        this.reporter = reporter;
        this.location = location;
        this.indexFile = new File(location, "index.xml.gz");
        this.client = client;
        this.url = url;
        this.name = name;
        this.location.mkdirs();
        this.validate();
        if (this.indexFile.isFile()) {
            r = this.readFile();
        } else {
            r = this.readRepository();
            this.save(r);
        }
        this.bridge = new BridgeRepository(r);
    }

    private void validate() {
        if (!this.location.isDirectory()) {
            throw new IllegalArgumentException("%s cannot be made a directory" + this.location);
        }
    }

    File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        Resource resource = this.getBridge().get(bsn, version);
        if (resource == null) {
            return null;
        }
        ResourceUtils.ContentCapability contentCapability = ResourceUtils.getContentCapability(resource);
        if (contentCapability == null) {
            return null;
        }
        URI url = contentCapability.url();
        File source = this.client.getCacheFileFor(url);
        final File link = new File(this.location, bsn + "-" + version + ".jar");
        if (link.isFile()) {
            Files.delete(link.toPath());
        }
        Files.createLink(link.toPath(), source.toPath());
        Promise go = this.client.build().useCache(MAX_STALE).async(url.toURL()).map((Function)new Function<File, File>(){

            public File apply(File t) {
                return link;
            }
        });
        if (listeners.length == 0) {
            return (File)go.getValue();
        }
        new DownloadListenerPromise(this.reporter, this.name + ": get " + bsn + ";" + version + " " + url, go, listeners);
        return link;
    }

    List<String> list(String pattern) throws Exception {
        return this.getBridge().list(pattern);
    }

    SortedSet<Version> versions(String bsn) throws Exception {
        return this.getBridge().versions(bsn);
    }

    private Repository readFile() throws Exception {
        try (XMLResourceParser xp = new XMLResourceParser(this.indexFile.toURI());){
            List resources = xp.parse();
            ResourcesRepository resourcesRepository = new ResourcesRepository((Collection)resources);
            return resourcesRepository;
        }
    }

    private Repository readRepository() throws Exception {
        P2Impl p2 = new P2Impl(this.client, this.url, Processor.getExecutor());
        List<Artifact> artifacts = p2.getArtifacts();
        ArrayList<Promise> fetched = new ArrayList<Promise>(artifacts.size());
        HashSet<URI> visited = new HashSet<URI>(artifacts.size());
        for (final Artifact a : artifacts) {
            if (!visited.add(a.uri)) continue;
            Promise promise = this.client.build().useCache(MAX_STALE).async(a.uri.toURL()).map((Function)new Function<File, Resource>(){

                public Resource apply(File file) {
                    try {
                        ResourceBuilder rb = new ResourceBuilder();
                        rb.addFile(file, a.uri);
                        return rb.build();
                    }
                    catch (Exception e) {
                        P2Indexer.this.reporter.trace("%s: Failed to create resource for %s from %s: %s", new Object[]{P2Indexer.this.name, a, file, e});
                        return RECOVERY;
                    }
                }
            }).recover(new Function<Promise<?>, Resource>(){

                public Resource apply(Promise<?> failed) {
                    try {
                        P2Indexer.this.reporter.trace("%s: Failed to create resource for %s: %s", new Object[]{P2Indexer.this.name, a, failed.getFailure()});
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return RECOVERY;
                }
            });
            fetched.add(promise);
        }
        Promise all = Promises.all(fetched);
        return (Repository)all.map((Function)new Function<List<Resource>, ResourcesRepository>(){

            public ResourcesRepository apply(List<Resource> resources) {
                ResourcesRepository rr = new ResourcesRepository();
                for (Resource resource : resources) {
                    if (resource == RECOVERY) continue;
                    rr.add(resource);
                }
                return rr;
            }
        }).getValue();
    }

    private void save(Repository repository) throws IOException, Exception {
        XMLResourceGenerator xrg = new XMLResourceGenerator();
        xrg.repository(repository).name(this.name).save(this.indexFile);
    }

    Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return this.getBridge().getRepository().findProviders(requirements);
    }

    public void refresh() throws Exception {
        Repository repository = this.readRepository();
        this.save(repository);
        this.bridge = new BridgeRepository(repository);
    }

    @Override
    public void close() throws IOException {
    }

    BridgeRepository getBridge() {
        return this.bridge;
    }
}

