/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidJpsProjectUtil {
    @NonNls
    public static final String ANDROID_STORAGE_DIR = "android";
    @NonNls
    public static final String GENERATED_RESOURCES_DIR_NAME = "generated_resources";
    @NonNls
    private static final String GENERATED_SOURCES_FOLDER_NAME = "generated_sources";
    @NonNls
    private static final String COPIED_SOURCES_FOLDER_NAME = "copied_sources";

    static JpsAndroidModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getExtension"));
        }
        return (JpsAndroidModuleExtension)module.getContainer().getChild(JpsAndroidModuleExtensionImpl.KIND);
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "isAndroidProjectWithoutGradleFacet"));
        }
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(project.getModules());
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "isAndroidProjectWithoutGradleFacet"));
        }
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(chunk.getModules());
    }

    private static boolean isAndroidProjectWithoutGradleFacet(@NotNull Collection<JpsModule> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "isAndroidProjectWithoutGradleFacet"));
        }
        boolean hasAndroidFacet = false;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension androidFacet = AndroidJpsProjectUtil.getExtension(module);
            if (androidFacet == null) continue;
            hasAndroidFacet = true;
            if (!androidFacet.isGradleProject()) continue;
            return false;
        }
        return hasAndroidFacet;
    }

    @NotNull
    public static File getGeneratedResourcesStorage(@NotNull JpsModule module, BuildDataManager dataManager) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedResourcesStorage"));
        }
        File file = AndroidJpsProjectUtil.getGeneratedResourcesStorage(module, dataManager.getDataPaths());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedResourcesStorage"));
        }
        return file;
    }

    @NotNull
    static File getGeneratedResourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedResourcesStorage"));
        }
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedResourcesStorage"));
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_RESOURCES_DIR_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedResourcesStorage"));
        }
        return file;
    }

    @NotNull
    public static File getStorageFile(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStorageRoot", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getStorageFile"));
        }
        if (storageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageName", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getStorageFile"));
        }
        File file = new File(AndroidJpsProjectUtil.getStorageDir(dataStorageRoot, storageName), storageName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getStorageFile"));
        }
        return file;
    }

    @NotNull
    public static File getStorageDir(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStorageRoot", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getStorageDir"));
        }
        if (storageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageName", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getStorageDir"));
        }
        File file = new File(new File(dataStorageRoot, ANDROID_STORAGE_DIR), storageName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getStorageDir"));
        }
        return file;
    }

    @NotNull
    public static File getGeneratedSourcesStorage(@NotNull JpsModule module, BuildDataPaths dataPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedSourcesStorage"));
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_SOURCES_FOLDER_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getGeneratedSourcesStorage"));
        }
        return file;
    }

    @NotNull
    public static File getCopiedSourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getCopiedSourcesStorage"));
        }
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getCopiedSourcesStorage"));
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsProjectUtil.getStorageDir(targetDataRoot, COPIED_SOURCES_FOLDER_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidJpsProjectUtil", "getCopiedSourcesStorage"));
        }
        return file;
    }
}

