/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ProgressConsumer;

public class ArtifactRepositoryManager {
    private static final String ARTIFACT_EXTENSION = "jar";
    private final VersionScheme myVersioning;
    private final DefaultRepositorySystemSession mySession;
    public static final List<RemoteRepository> REMOTE_REPOSITORIES = Collections.singletonList(new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build());
    private static final RepositorySystem ourSystem;

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath) {
        if (localRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRepositoryPath", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        this(localRepositoryPath, ProgressConsumer.DEAF);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, final @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRepositoryPath", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        if (progressConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressConsumer", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        this.myVersioning = new GenericVersionScheme();
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (progressConsumer != ProgressConsumer.DEAF) {
            session.setTransferListener((TransferListener)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TransferListener.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object event = args[0];
                    if (event instanceof TransferEvent) {
                        progressConsumer.consume(event.toString());
                    }
                    return null;
                }
            }));
        }
        session.setLocalRepositoryManager(ourSystem.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepositoryPath)));
        session.setReadOnly();
        this.mySession = session;
    }

    public Collection<File> resolveDependency(String groupId, String artifactId, String version) throws Exception {
        DependencyRequest dependencyRequest = new DependencyRequest(ArtifactRepositoryManager.createCollectRequest(groupId, artifactId, this.toVersion(version)), DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}));
        DependencyResult result = ourSystem.resolveDependencies((RepositorySystemSession)this.mySession, dependencyRequest);
        ArrayList<File> files = new ArrayList<File>();
        for (ArtifactResult artifactResult : result.getArtifactResults()) {
            files.add(artifactResult.getArtifact().getFile());
        }
        return files;
    }

    private static CollectRequest createCollectRequest(String groupId, String artifactId, Version version) {
        return ArtifactRepositoryManager.createCollectRequest(groupId, artifactId, Collections.singleton(version));
    }

    private static CollectRequest createCollectRequest(String groupId, String artifactId, Collection<Version> versions) {
        CollectRequest request = new CollectRequest();
        for (Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, versions)) {
            request.addDependency(new Dependency(artifact, "compile"));
        }
        return request.setRepositories(REMOTE_REPOSITORIES);
    }

    private Version toVersion(String version) throws InvalidVersionSpecificationException {
        return this.myVersioning.parseVersion(version);
    }

    private static List<Artifact> toArtifacts(String groupId, String artifactId, Collection<Version> versions) {
        if (versions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>(versions.size());
        for (Version version : versions) {
            result.add((Artifact)new DefaultArtifact(groupId, artifactId, ARTIFACT_EXTENSION, version.toString()));
        }
        return result;
    }

    static {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        });
        ourSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

