/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.api;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.TaskFuture;

public class TaskFutureAdapter<T>
implements TaskFuture<T> {
    @NotNull
    private final Future<T> myFuture;

    public TaskFutureAdapter(@NotNull Future<T> future) {
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "org/jetbrains/jps/api/TaskFutureAdapter", "<init>"));
        }
        this.myFuture = future;
    }

    @Override
    public void waitFor() {
        try {
            this.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) {
        try {
            this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return this.isDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.myFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.myFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.myFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.myFuture.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "org/jetbrains/jps/api/TaskFutureAdapter", "get"));
        }
        return this.myFuture.get(timeout, (TimeUnit)unit);
    }
}

