/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.pom.provider;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Workspace;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.repository.BridgeRepository;
import aQute.bnd.repository.maven.pom.provider.InnerRepository;
import aQute.bnd.repository.maven.pom.provider.PomConfiguration;
import aQute.bnd.repository.maven.pom.provider.PomRepository;
import aQute.bnd.repository.maven.pom.provider.SearchRepository;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.util.repository.DownloadListenerPromise;
import aQute.bnd.version.Version;
import aQute.lib.converter.Converter;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.maven.api.Archive;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenBackingRepository;
import aQute.maven.provider.MavenRepository;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;
import org.osgi.util.promise.Promise;

@BndPlugin(name="PomRepository")
public class BndPomRepository
extends BaseRepository
implements Plugin,
RegistryPlugin,
RepositoryPlugin,
Refreshable,
Actionable {
    static final String MAVEN_REPO_LOCAL = System.getProperty("maven.repo.local", "~/.m2/repository");
    boolean inited;
    private PomConfiguration configuration;
    private Registry registry;
    private String name;
    private Reporter reporter = new Slf4jReporter(BndPomRepository.class);
    private InnerRepository repoImpl;
    private Revision revision;
    private BridgeRepository bridge;
    private URI pomFile;
    private String query;
    private String queryUrl;

    public synchronized void init() {
        try {
            if (this.inited) {
                return;
            }
            this.inited = true;
            Workspace workspace = (Workspace)this.registry.getPlugin(Workspace.class);
            HttpClient client = (HttpClient)this.registry.getPlugin(HttpClient.class);
            File localRepo = IO.getFile(this.configuration.local(MAVEN_REPO_LOCAL));
            File location = workspace.getFile(this.getLocation());
            List<MavenBackingRepository> release = MavenBackingRepository.create(this.configuration.releaseUrls(), this.reporter, localRepo, client);
            List<MavenBackingRepository> snapshot = MavenBackingRepository.create(this.configuration.snapshotUrls(), this.reporter, localRepo, client);
            MavenRepository repository = new MavenRepository(localRepo, this.name, release, snapshot, Processor.getExecutor(), this.reporter, null);
            if (this.pomFile != null) {
                this.repoImpl = new PomRepository(repository, client, location, this.pomFile);
            } else if (this.revision != null) {
                this.repoImpl = new PomRepository(repository, client, location, this.revision);
            } else if (this.query != null) {
                this.repoImpl = new SearchRepository(repository, location, this.query, this.queryUrl, (Reporter)workspace, client);
            } else {
                repository.close();
                throw new IllegalStateException("We have neither a pom, revision, or query set!");
            }
            this.bridge = new BridgeRepository((Repository)this.repoImpl);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public boolean refresh() throws Exception {
        this.init();
        this.repoImpl.refresh();
        this.bridge = new BridgeRepository((Repository)this.repoImpl);
        return true;
    }

    public void setProperties(Map<String, String> map) throws Exception {
        this.configuration = Converter.cnv(PomConfiguration.class, map);
        if (this.configuration.name() == null) {
            throw new IllegalArgumentException("Must get a name");
        }
        this.name = this.configuration.name();
        if (this.configuration.pom() != null) {
            File f = IO.getFile(this.configuration.pom());
            this.pomFile = f.isFile() ? f.toURI() : URI.create(this.configuration.pom());
        } else if (this.configuration.revision() != null) {
            this.revision = Revision.valueOf(this.configuration.revision());
            if (this.revision == null) {
                throw new IllegalArgumentException("Revision is neither a file nor a revision " + this.configuration.revision());
            }
        } else if (this.configuration.query() != null) {
            this.query = this.configuration.query();
            this.queryUrl = this.configuration.queryUrl("http://search.maven.org/solrsearch/select");
        } else {
            throw new IllegalArgumentException("Neither pom, revision nor query property are set");
        }
        this.inited = false;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        this.init();
        return this.repoImpl.findProviders(requirements);
    }

    public void setReporter(Reporter processor) {
        this.reporter = processor;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException();
    }

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        this.init();
        BridgeRepository.ResourceInfo resource = this.bridge.getInfo(bsn, version);
        if (resource == null) {
            return null;
        }
        String name = resource.getInfo().name();
        Archive archive = Archive.valueOf(name);
        Promise<File> p = this.repoImpl.getMavenRepository().get(archive);
        if (listeners.length == 0) {
            return (File)p.getValue();
        }
        new DownloadListenerPromise(this.reporter, name + ": get " + bsn + ";" + version, p, listeners);
        return this.repoImpl.getMavenRepository().toLocalFile(archive);
    }

    public boolean canWrite() {
        return false;
    }

    public List<String> list(String pattern) throws Exception {
        this.init();
        return this.bridge.list(pattern);
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        this.init();
        return this.bridge.versions(bsn);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.configuration.location("cnf/cache/pom-" + this.name + ".xml");
    }

    public String toString() {
        return this.name;
    }

    public File getRoot() throws Exception {
        return this.repoImpl.getLocation();
    }

    public Map<String, Runnable> actions(Object ... target) throws Exception {
        return null;
    }

    public String tooltip(Object ... target) throws Exception {
        this.init();
        return this.bridge.tooltip(target);
    }

    public String title(Object ... target) throws Exception {
        this.init();
        return this.bridge.title(target);
    }
}

