/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.contributors.AbstractXmlDocumentArtefactAnalyser;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import com.springsource.bundlor.util.ClassNameUtils;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Log4JXmlArtifactAnalyzer
extends AbstractXmlDocumentArtefactAnalyser {
    private static final String LOG4J_DTD = "com/springsource/bundlor/support/contributors/log4j.dtd";
    private final XPathExpression expression;

    public Log4JXmlArtifactAnalyzer() {
        super(false, new Log4JEntityResolver());
        try {
            XPathFactory newInstance = XPathFactory.newInstance();
            XPath xpath = newInstance.newXPath();
            this.expression = xpath.compile("//appender/@class | //layout/@class");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void analyse(Document doc, String artefactName, PartialManifest partialManifest) throws Exception {
        NodeList nodes = (NodeList)this.expression.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodes.getLength()) {
            Attr attribute = (Attr)nodes.item(i);
            String candidateType = attribute.getValue();
            if (ClassNameUtils.isValidFqn(candidateType)) {
                partialManifest.recordReferencedType(candidateType);
            }
            ++i;
        }
    }

    public boolean canAnalyse(String artefactName) {
        return "log4j.xml".equals(artefactName);
    }

    private static class Log4JEntityResolver
    implements EntityResolver {
        private Log4JEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("log4j.dtd")) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                return new InputSource(classLoader.getResourceAsStream(Log4JXmlArtifactAnalyzer.LOG4J_DTD));
            }
            return null;
        }
    }
}

