/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.util;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class OsgiBuildUtil {
    private static final boolean ourMavenPluginLoaded;

    @NotNull
    public static Properties getMavenProjectProperties(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
        }
        Properties result = new Properties();
        if (ourMavenPluginLoaded) {
            OsgiBuildUtil.collectMavenProjectProperties(context, module, result);
        }
        Properties properties = result;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
        }
        return properties;
    }

    @Nullable
    public static File getMavenProjectPath(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectPath"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectPath"));
        }
        return ourMavenPluginLoaded ? OsgiBuildUtil.findMavenProjectPath(context, module) : null;
    }

    private static void collectMavenProjectProperties(CompileContext context, JpsModule module, Properties result) {
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig != null) {
            JpsJavaExtensionService.dependencies((JpsModule)module).recursively().productionOnly().processModules(module1 -> {
                MavenModuleResourceConfiguration moduleConfig = (MavenModuleResourceConfiguration)projectConfig.moduleConfigurations.get(module1.getName());
                if (moduleConfig != null) {
                    for (Map.Entry entry : moduleConfig.properties.entrySet()) {
                        result.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            });
        }
    }

    private static File findMavenProjectPath(CompileContext context, JpsModule module) {
        MavenModuleResourceConfiguration moduleConfig;
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig != null && (moduleConfig = (MavenModuleResourceConfiguration)projectConfig.moduleConfigurations.get(module.getName())) != null) {
            return new File(FileUtil.toSystemDependentName((String)moduleConfig.directory), "pom.xml");
        }
        return null;
    }

    @Nullable
    public static File findFileInModuleContentRoots(@NotNull JpsModule module, @NotNull String relativePath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "findFileInModuleContentRoots"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "findFileInModuleContentRoots"));
        }
        String ioRelativePath = FileUtil.toSystemDependentName((String)relativePath);
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            File result = new File(root, ioRelativePath);
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }

    static {
        boolean pluginLoaded = false;
        try {
            Class.forName("org.jetbrains.jps.maven.model.JpsMavenExtensionService");
            pluginLoaded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ourMavenPluginLoaded = pluginLoaded;
    }
}

