/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.javac;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
implements PatternAwareOutputParser {
    private static final char COLON = ':';
    private static final String WARNING_PREFIX = "warning:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        block26: {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "parse"));
            }
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "parse"));
            }
            if (messages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "parse"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "parse"));
            }
            int colonIndex1 = line.indexOf(58);
            if (colonIndex1 == 1) {
                colonIndex1 = line.indexOf(58, colonIndex1 + 1);
            }
            if (colonIndex1 >= 0) {
                String part1 = line.substring(0, colonIndex1).trim();
                if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                    String text = line.substring(colonIndex1 + 1).trim();
                    JavacOutputParser.addMessage(new Message(Message.Kind.ERROR, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
                    return true;
                }
                if (part1.equalsIgnoreCase("warning")) {
                    String text = line.substring(colonIndex1 + 1).trim();
                    JavacOutputParser.addMessage(new Message(Message.Kind.WARNING, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
                    return true;
                }
                if (part1.equalsIgnoreCase("javac")) {
                    JavacOutputParser.addMessage(new Message(Message.Kind.ERROR, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
                    return true;
                }
                int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
                if (colonIndex2 >= 0) {
                    File file = new File(part1);
                    if (!file.isFile()) {
                        return false;
                    }
                    try {
                        int column;
                        int lineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                        String text = line.substring(colonIndex2 + 1).trim();
                        Message.Kind kind = Message.Kind.ERROR;
                        if (text.startsWith(WARNING_PREFIX)) {
                            text = text.substring(WARNING_PREFIX.length()).trim();
                            kind = Message.Kind.WARNING;
                        }
                        if (!file.getPath().endsWith(".java")) {
                            return false;
                        }
                        List<Object> messageList = Lists.newArrayList();
                        messageList.add(text);
                        String prevLine = null;
                        while (true) {
                            String nextLine;
                            if ((nextLine = reader.readLine()) == null) {
                                return false;
                            }
                            if (nextLine.trim().equals("^")) {
                                column = nextLine.indexOf(94);
                                Object messageEnd = reader.readLine();
                                while (JavacOutputParser.isMessageEnd((String)messageEnd)) {
                                    messageList.add(((String)messageEnd).trim());
                                    messageEnd = reader.readLine();
                                }
                                if (messageEnd == null) break;
                                reader.pushBack();
                                break;
                            }
                            if (prevLine != null) {
                                messageList.add(prevLine);
                            }
                            prevLine = nextLine;
                        }
                        if (column < 0) break block26;
                        messageList = JavacOutputParser.convertMessages((List<String>)messageList);
                        StringBuilder buf = StringBuilderSpinAllocator.alloc();
                        try {
                            for (String string : messageList) {
                                if (buf.length() > 0) {
                                    buf.append(SystemProperties.getLineSeparator());
                                }
                                buf.append(string);
                            }
                            Message msg = new Message(kind, buf.toString(), new SourceFilePosition(file, new SourcePosition(lineNumber - 1, column, -1)), new SourceFilePosition[0]);
                            JavacOutputParser.addMessage(msg, messages);
                        }
                        finally {
                            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                        }
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            JavacOutputParser.addMessage(new Message(Message.Kind.ERROR, "Out of memory.", SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
            return true;
        }
        return false;
    }

    private static void addMessage(@NotNull Message message, @NotNull List<Message> messages) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "addMessage"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "addMessage"));
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = lastMessage.equals((Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
    }

    @Contract(value="null -> false")
    private static boolean isMessageEnd(@Nullable String line) {
        return line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0));
    }

    @NotNull
    private static List<String> convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "convertMessages"));
        }
        if (messages.size() <= 1) {
            List<String> list = messages;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "convertMessages"));
            }
            return list;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        List<String> list = messages;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser", "convertMessages"));
        }
        return list;
    }
}

