/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.output;

import com.android.ide.common.blame.SourceFragmentPositionRange;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class GradleMessage {
    @SerializedName(value="kind")
    private final Kind mKind;
    @SerializedName(value="text")
    private final String mText;
    @SerializedName(value="sourcePath")
    private final String mSourcePath;
    @SerializedName(value="position")
    private final SourceFragmentPositionRange mPosition;
    @SerializedName(value="original")
    private final String mOriginal;

    public GradleMessage(Kind kind, String text) {
        this(kind, text, null, new SourceFragmentPositionRange(), text);
    }

    public GradleMessage(Kind kind, String text, String sourcePath, SourceFragmentPositionRange position, String original) {
        this.mKind = kind;
        this.mText = text;
        this.mSourcePath = sourcePath;
        this.mPosition = position;
        this.mOriginal = original;
    }

    public GradleMessage(Kind kind, String text, String sourcePath, int line, int column) {
        this(kind, text, sourcePath, new SourceFragmentPositionRange(line, column, -1), text);
    }

    public Kind getKind() {
        return this.mKind;
    }

    public String getText() {
        return this.mText;
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    public int getLineNumber() {
        return this.mPosition.getStartLine();
    }

    public int getColumn() {
        return this.mPosition.getStartColumn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleMessage that = (GradleMessage)o;
        return Objects.equal((Object)this.mPosition, (Object)that.mPosition) && this.mKind == that.mKind && Objects.equal((Object)this.mSourcePath, (Object)that.mSourcePath) && Objects.equal((Object)this.mText, (Object)that.mText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mPosition, this.mKind, this.mSourcePath, this.mText});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.mKind) + ", text=\"" + this.mText + '\"' + ", sourcePath=" + this.mSourcePath + ", position=" + this.mPosition.toString() + ']';
    }

    public SourceFragmentPositionRange getPosition() {
        return this.mPosition;
    }

    public String getOriginal() {
        return this.mOriginal;
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO,
        STATISTICS,
        SIMPLE;


        public static Kind findIgnoringCase(String s) {
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equalsIgnoreCase(s)) continue;
                return kind;
            }
            return null;
        }
    }
}

