/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.classpath;

import com.springsource.bundlor.ClassPathEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;

final class FileSystemClassPathEntry
implements ClassPathEntry {
    private final File root;
    private final File file;

    public FileSystemClassPathEntry(File root, File file) {
        this.root = root;
        this.file = file;
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Reader getReader() {
        try {
            return new FileReader(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public String toString() {
        return this.getName();
    }
}

