/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.jarRepository.impl;

import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;

public class JpsRemoteRepositoriesConfigurationImpl
extends JpsElementBase<JpsRemoteRepositoriesConfigurationImpl>
implements JpsRemoteRepositoriesConfiguration {
    public static final JpsElementChildRole<JpsRemoteRepositoriesConfiguration> ROLE = JpsElementChildRoleBase.create("remote repositories configuration");
    private final List<JpsRemoteRepositoryDescription> myRepositories = new SmartList();

    public JpsRemoteRepositoriesConfigurationImpl() {
        this(Arrays.asList(new JpsRemoteRepositoryDescription("central", "Maven Central repository", "https://repo1.maven.org/maven2"), new JpsRemoteRepositoryDescription("jboss.community", "JBoss Community repository", "https://repository.jboss.org/nexus/content/repositories/public/")));
    }

    public JpsRemoteRepositoriesConfigurationImpl(List<JpsRemoteRepositoryDescription> repositories) {
        this.myRepositories.addAll(repositories);
    }

    @Override
    @NotNull
    public JpsRemoteRepositoriesConfigurationImpl createCopy() {
        JpsRemoteRepositoriesConfigurationImpl jpsRemoteRepositoriesConfigurationImpl = new JpsRemoteRepositoriesConfigurationImpl(this.myRepositories);
        if (jpsRemoteRepositoriesConfigurationImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/jarRepository/impl/JpsRemoteRepositoriesConfigurationImpl", "createCopy"));
        }
        return jpsRemoteRepositoriesConfigurationImpl;
    }

    @Override
    public void applyChanges(@NotNull JpsRemoteRepositoriesConfigurationImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/model/jarRepository/impl/JpsRemoteRepositoriesConfigurationImpl", "applyChanges"));
        }
        this.setRepositories(modified.getRepositories());
    }

    @Override
    public List<JpsRemoteRepositoryDescription> getRepositories() {
        return Collections.unmodifiableList(this.myRepositories);
    }

    @Override
    public void setRepositories(List<JpsRemoteRepositoryDescription> repositories) {
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
    }
}

