/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javaee.model.JpsConfigFile;
import org.jetbrains.jps.javaee.model.JpsConfigFileCollectionElement;
import org.jetbrains.jps.javaee.model.JpsConfigFileMetaData;
import org.jetbrains.jps.javaee.model.JpsConfigFileMetaDataProvider;
import org.jetbrains.jps.javaee.model.JpsJavaeeModuleExtension;
import org.jetbrains.jps.javaee.model.impl.JpsConfigFileMetaDataImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.facet.FacetState;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JpsJavaeeModuleExtensionSerializerBase<T extends JpsJavaeeModuleExtension>
extends JpsFacetConfigurationSerializer<T> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.javaee.model.impl.JpsJavaeeModuleExtensionLoaderBase");
    private static final String DESCRIPTORS_TAG = "descriptors";
    private static final String DESCRIPTOR_TAG = "deploymentDescriptor";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ID_ATTRIBUTE = "name";
    private final JpsElementCollectionRole<T> myCollectionRole;

    protected JpsJavaeeModuleExtensionSerializerBase(JpsElementChildRole<T> role, JpsElementCollectionRole<T> collectionRole, String facetTypeId) {
        super(role, facetTypeId, null);
        this.myCollectionRole = collectionRole;
    }

    public T loadExtension(Element configurationElement, String facetName, JpsModule module, JpsElement parentFacet) {
        JpsJavaeeModuleExtension e = (JpsJavaeeModuleExtension)this.loadExtension(configurationElement, facetName, parentFacet, module);
        return (T)((JpsJavaeeModuleExtension)((JpsElementCollection)module.getContainer().getOrSetChild(this.myCollectionRole)).addChild((JpsElement)e));
    }

    public boolean hasExtension(JpsModule module) {
        JpsElementCollection collection = (JpsElementCollection)module.getContainer().getChild(this.myCollectionRole);
        return collection != null && !collection.getElements().isEmpty();
    }

    public void saveExtension(JpsModule module, @NotNull List<FacetState> states) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeModuleExtensionSerializerBase", "saveExtension"));
        }
        JpsElementCollection collection = (JpsElementCollection)module.getContainer().getChild(this.myCollectionRole);
        if (collection != null) {
            for (JpsJavaeeModuleExtension extension : collection.getElements()) {
                FacetState state = new FacetState();
                state.setFacetType(this.getFacetTypeId());
                state.setName(extension.getName());
                Element tag = new Element("configuration");
                this.saveExtension(extension, tag, module);
                state.setConfiguration(tag);
                states.add(state);
            }
        }
    }

    protected static void loadJavaeeConfigFiles(JpsConfigFileCollectionElement extension, Element facetConfigurationElement) {
        JpsJavaeeModuleExtensionSerializerBase.loadConfigFiles(extension, facetConfigurationElement.getChild(DESCRIPTORS_TAG));
    }

    protected static void saveJavaeeConfigFiles(JpsConfigFileCollectionElement extension, Element facetConfigurationElement) {
        Element tag = new Element(DESCRIPTORS_TAG);
        JpsJavaeeModuleExtensionSerializerBase.saveConfigFiles(extension, tag);
        if (tag.getContentSize() > 0) {
            facetConfigurationElement.addContent(tag);
        }
    }

    public static void saveConfigFiles(JpsConfigFileCollectionElement extension, Element tag) {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (JpsConfigFile file : extension.getConfigFiles()) {
            String id = JpsJavaeeModuleExtensionSerializerBase.getMetaDataId(file.getMetaData());
            if (id == null) continue;
            files.add(Pair.create((Object)id, (Object)file));
        }
        files.sort((o1, o2) -> StringUtil.comparePairs((String)((String)o1.getFirst()), (String)((String)o2.getFirst()), (String)((JpsConfigFile)o1.getSecond()).getUrl(), (String)((JpsConfigFile)o2.getSecond()).getUrl(), (boolean)false));
        for (Pair pair : files) {
            Element fileTag = new Element(DESCRIPTOR_TAG);
            fileTag.setAttribute(ID_ATTRIBUTE, (String)pair.getFirst());
            fileTag.setAttribute(URL_ATTRIBUTE, ((JpsConfigFile)pair.getSecond()).getUrl());
            tag.addContent(fileTag);
        }
    }

    public static void loadConfigFiles(JpsConfigFileCollectionElement extension, @Nullable Element descriptorsElement) {
        for (Element descriptor : JDOMUtil.getChildren((Element)descriptorsElement, (String)DESCRIPTOR_TAG)) {
            String url = descriptor.getAttributeValue(URL_ATTRIBUTE);
            String id = descriptor.getAttributeValue(ID_ATTRIBUTE);
            JpsConfigFileMetaData metaData = JpsJavaeeModuleExtensionSerializerBase.getMetaData(id);
            if (metaData == null) {
                String dirName = id.contains("web") ? "WEB-INF" : "META-INF";
                metaData = new JpsConfigFileMetaDataImpl(dirName, id);
                LOG.info("Unknown config file id: " + id + ", relative output path is set to " + dirName);
            }
            extension.addConfigFile(metaData, url);
        }
    }

    @Nullable
    private static JpsConfigFileMetaData getMetaData(String id) {
        for (JpsConfigFileMetaDataProvider provider : JpsServiceManager.getInstance().getExtensions(JpsConfigFileMetaDataProvider.class)) {
            for (Pair<String, JpsConfigFileMetaData> pair : provider.getMetaDataList()) {
                if (!((String)pair.getFirst()).equals(id)) continue;
                return (JpsConfigFileMetaData)pair.getSecond();
            }
        }
        return null;
    }

    @Nullable
    private static String getMetaDataId(JpsConfigFileMetaData metaData) {
        for (JpsConfigFileMetaDataProvider provider : JpsServiceManager.getInstance().getExtensions(JpsConfigFileMetaDataProvider.class)) {
            for (Pair<String, JpsConfigFileMetaData> pair : provider.getMetaDataList()) {
                if (!((JpsConfigFileMetaData)pair.getSecond()).equals(metaData)) continue;
                return (String)pair.getFirst();
            }
        }
        return null;
    }
}

