/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsAndroidModuleExtensionImpl
extends JpsElementBase<JpsAndroidModuleExtensionImpl>
implements JpsAndroidModuleExtension {
    public static final JpsElementChildRoleBase<JpsAndroidModuleExtension> KIND = JpsElementChildRoleBase.create((String)"android extension");
    private final JpsAndroidModuleProperties myProperties;

    public JpsAndroidModuleExtensionImpl(JpsAndroidModuleProperties properties) {
        this.myProperties = properties;
    }

    @Override
    public JpsModule getModule() {
        return (JpsModule)this.getParent();
    }

    @NotNull
    public JpsAndroidModuleExtensionImpl createCopy() {
        JpsAndroidModuleExtensionImpl jpsAndroidModuleExtensionImpl = new JpsAndroidModuleExtensionImpl((JpsAndroidModuleProperties)XmlSerializerUtil.createCopy((Object)this.myProperties));
        if (jpsAndroidModuleExtensionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl", "createCopy"));
        }
        return jpsAndroidModuleExtensionImpl;
    }

    public void applyChanges(@NotNull JpsAndroidModuleExtensionImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl", "applyChanges"));
        }
        XmlSerializerUtil.copyBean((Object)modified.myProperties, (Object)this.myProperties);
        this.fireElementChanged();
    }

    @Override
    public String getCustomDebugKeyStorePath() {
        return JpsPathUtil.urlToPath((String)this.myProperties.CUSTOM_DEBUG_KEYSTORE_PATH);
    }

    @Override
    public List<AndroidNativeLibData> getAdditionalNativeLibs() {
        ArrayList<AndroidNativeLibData> libDatas = new ArrayList<AndroidNativeLibData>();
        for (JpsAndroidModuleProperties.AndroidNativeLibDataEntry nativeLib : this.myProperties.myNativeLibs) {
            if (nativeLib.myArchitecture == null || nativeLib.myUrl == null || nativeLib.myTargetFileName == null) continue;
            libDatas.add(new AndroidNativeLibData(nativeLib.myArchitecture, JpsPathUtil.urlToPath((String)nativeLib.myUrl), nativeLib.myTargetFileName));
        }
        return libDatas;
    }

    @Override
    public boolean isUseCustomManifestPackage() {
        return this.myProperties.USE_CUSTOM_MANIFEST_PACKAGE;
    }

    @Override
    public String getCustomManifestPackage() {
        return this.myProperties.CUSTOM_MANIFEST_PACKAGE;
    }

    @Override
    public String getAdditionalPackagingCommandLineParameters() {
        return this.myProperties.ADDITIONAL_PACKAGING_COMMAND_LINE_PARAMETERS;
    }

    @Override
    public boolean isManifestMergingEnabled() {
        return this.myProperties.ENABLE_MANIFEST_MERGING;
    }

    @Override
    public boolean isPreDexingEnabled() {
        return this.myProperties.ENABLE_PRE_DEXING;
    }

    @Override
    public boolean isMultiDexEnabled() {
        return this.myProperties.ENABLE_MULTI_DEX;
    }

    @Override
    public String getMainDexList() {
        return this.myProperties.MAIN_DEX_LIST;
    }

    @Override
    public boolean isMinimalMainDex() {
        return this.myProperties.MINIMAL_MAIN_DEX;
    }

    @Override
    public boolean isCopyCustomGeneratedSources() {
        return this.myProperties.COMPILE_CUSTOM_GENERATED_SOURCES;
    }

    @Override
    public File getResourceDir() {
        File resDir = this.findFileByRelativeModulePath(this.myProperties.RES_FOLDER_RELATIVE_PATH, false);
        return resDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(resDir) : null;
    }

    @Override
    @NotNull
    public List<File> getResourceOverlayDirs() {
        List<String> paths = this.myProperties.RES_OVERLAY_FOLDERS;
        if (paths == null || paths.isEmpty()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl", "getResourceOverlayDirs"));
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull(paths, (Function)new Function<String, File>(){

            public File fun(String s) {
                File resDir = JpsAndroidModuleExtensionImpl.this.findFileByRelativeModulePath(s, false);
                return resDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(resDir) : null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl", "getResourceOverlayDirs"));
        }
        return list;
    }

    @Override
    public File getResourceDirForCompilation() {
        File resDir = this.findFileByRelativeModulePath(this.myProperties.CUSTOM_APK_RESOURCE_FOLDER, false);
        return resDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(resDir) : null;
    }

    @Override
    public File getManifestFile() {
        File manifestFile = this.findFileByRelativeModulePath(this.myProperties.MANIFEST_FILE_RELATIVE_PATH, false);
        return manifestFile != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(manifestFile) : null;
    }

    @Override
    public File getManifestFileForCompilation() {
        File manifestFile = this.findFileByRelativeModulePath(this.myProperties.CUSTOM_COMPILER_MANIFEST, false);
        return manifestFile != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(manifestFile) : null;
    }

    @Override
    @Nullable
    public List<File> getProguardConfigFiles(@NotNull JpsModule module) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl", "getProguardConfigFiles"));
        }
        JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
        String sdkHomePath = sdk != null ? FileUtil.toSystemIndependentName((String)sdk.getHomePath()) : null;
        List<String> urls = this.myProperties.myProGuardCfgFiles;
        if (urls == null) {
            return null;
        }
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String url : urls) {
            if (sdkHomePath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomePath);
            }
            result.add(JpsPathUtil.urlToFile((String)url));
        }
        return result;
    }

    @Override
    public File getAssetsDir() {
        File manifestFile = this.findFileByRelativeModulePath(this.myProperties.ASSETS_FOLDER_RELATIVE_PATH, false);
        return manifestFile != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(manifestFile) : null;
    }

    @Override
    public File getAaptGenDir() throws IOException {
        File aaptGenDir = this.findFileByRelativeModulePath(this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT, true);
        return aaptGenDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(aaptGenDir) : null;
    }

    @Override
    public File getAidlGenDir() throws IOException {
        File aidlGenDir = this.findFileByRelativeModulePath(this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL, true);
        return aidlGenDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(aidlGenDir) : null;
    }

    public JpsAndroidModuleProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public File getNativeLibsDir() {
        File nativeLibsFolder = this.findFileByRelativeModulePath(this.myProperties.LIBS_FOLDER_RELATIVE_PATH, true);
        return nativeLibsFolder != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(nativeLibsFolder) : null;
    }

    @Override
    public File getProguardLogsDir() {
        File proguardLogsDir = this.findFileByRelativeModulePath(this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH, false);
        return proguardLogsDir != null ? JpsAndroidModuleExtensionImpl.canonizeFilePath(proguardLogsDir) : null;
    }

    private static File canonizeFilePath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/model/impl/JpsAndroidModuleExtensionImpl", "canonizeFilePath"));
        }
        return new File(FileUtil.toCanonicalPath((String)file.getPath()));
    }

    @Nullable
    private File findFileByRelativeModulePath(String relativePath, boolean checkExistence) {
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        JpsModule module = this.getModule();
        File moduleBaseDir = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        if (moduleBaseDir != null) {
            String absPath = FileUtil.toSystemDependentName((String)(moduleBaseDir.getAbsolutePath() + relativePath));
            File f = new File(absPath);
            if (!checkExistence || f.exists()) {
                return f;
            }
        }
        return null;
    }

    @Override
    public boolean isGradleProject() {
        return !this.myProperties.ALLOW_USER_CONFIGURATION;
    }

    @Override
    public boolean isLibrary() {
        return this.myProperties.PROJECT_TYPE == 1 || this.myProperties.PROJECT_TYPE == 3;
    }

    @Override
    public boolean useCustomResFolderForCompilation() {
        return this.myProperties.USE_CUSTOM_APK_RESOURCE_FOLDER;
    }

    @Override
    public boolean useCustomManifestForCompilation() {
        return this.myProperties.USE_CUSTOM_COMPILER_MANIFEST;
    }

    @Override
    public boolean isPackTestCode() {
        return this.myProperties.PACK_TEST_CODE;
    }

    @Override
    public boolean isIncludeAssetsFromLibraries() {
        return this.myProperties.myIncludeAssetsFromLibraries;
    }

    @Override
    public boolean isRunProcessResourcesMavenTask() {
        return this.myProperties.RUN_PROCESS_RESOURCES_MAVEN_TASK;
    }

    @Override
    public boolean isRunProguard() {
        return this.myProperties.RUN_PROGUARD;
    }

    @Override
    public String getApkRelativePath() {
        return this.myProperties.APK_PATH;
    }
}

