/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.Revision;
import com.android.repository.api.Dependency;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.RevisionType;
import com.android.repository.impl.meta.TypeDetails;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class RepoPackageImpl
implements RepoPackage {
    @Override
    @XmlTransient
    public abstract TypeDetails getTypeDetails();

    @Override
    @XmlTransient
    public Revision getVersion() {
        return this.getRevision().toRevision();
    }

    protected abstract RevisionType getRevision();

    @Override
    @XmlTransient
    public abstract String getDisplayName();

    protected UsesLicense getUsesLicense() {
        return null;
    }

    @Override
    @XmlTransient
    public License getLicense() {
        UsesLicense usesLicense = this.getUsesLicense();
        if (usesLicense != null) {
            return usesLicense.getRef();
        }
        return null;
    }

    protected void setUsesLicense(UsesLicense license) {
    }

    public void setLicense(License l) {
        UsesLicense ul = null;
        if (l != null) {
            ul = this.createFactory().createLicenseRefType();
            ul.setRef(l);
        }
        this.setUsesLicense(ul);
    }

    protected Dependencies getDependencies() {
        return null;
    }

    @Override
    public Collection<Dependency> getAllDependencies() {
        Dependencies dependencies = this.getDependencies();
        if (dependencies == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(dependencies.getDependency());
    }

    @Override
    @XmlTransient
    public String getPath() {
        return "";
    }

    @Override
    public boolean obsolete() {
        return this.isObsolete() != null && this.isObsolete() != false;
    }

    protected Boolean isObsolete() {
        return null;
    }

    @Override
    public int compareTo(RepoPackage o) {
        int result = ComparisonChain.start().compare((Comparable)((Object)this.getPath()), (Comparable)((Object)o.getPath())).compare((Comparable)this.getVersion(), (Comparable)o.getVersion()).result();
        if (result != 0) {
            return result;
        }
        if (this instanceof LocalPackage ^ o instanceof LocalPackage || this instanceof RemotePackage ^ o instanceof RemotePackage) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return 0;
    }

    public abstract void addTo(Repository var1);

    public boolean equals(Object obj) {
        return obj instanceof RepoPackage && this.compareTo((RepoPackage)obj) == 0;
    }

    public int hashCode() {
        return this.getPath().hashCode() * 37 + this.getVersion().hashCode();
    }

    protected void setRevision(RevisionType revision) {
    }

    public void setVersion(Revision revision) {
        this.setRevision(this.createFactory().createRevisionType(revision));
    }

    public void setDependencies(Dependencies dependencies) {
    }

    public void setTypeDetails(TypeDetails details) {
    }

    public void setDisplayName(String name) {
    }

    public void setPath(String path) {
    }

    public void setObsolete(Boolean obsolete) {
    }

    public void addDependency(Dependency dep) {
        Dependencies dependencies = this.getDependencies();
        if (dependencies == null) {
            dependencies = this.createFactory().createDependenciesType();
            this.setDependencies(dependencies);
        }
        this.getDependencies().getDependency().add(dep);
    }

    @XmlTransient
    public static abstract class Dependencies {
        public abstract List<Dependency> getDependency();
    }

    @XmlTransient
    public static abstract class UsesLicense {
        public abstract License getRef();

        public void setRef(License ref) {
        }
    }

    public static abstract class Archives {
        public abstract List<Archive> getArchive();
    }
}

