/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsModuleOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class MavenWebArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    private static final Logger LOG = Logger.getInstance(MavenWebArtifactRootCopyingHandlerProvider.class);

    @Nullable
    public FileCopyingHandler createCustomHandler(@NotNull JpsArtifact artifact, @NotNull File root, @NotNull JpsPackagingElement contextElement, @NotNull JpsModel model, @NotNull BuildDataPaths buildDataPaths) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (buildDataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDataPaths", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (contextElement instanceof JpsModuleOutputPackagingElement) {
            return null;
        }
        MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(buildDataPaths);
        if (projectConfiguration == null) {
            return null;
        }
        MavenWebArtifactConfiguration artifactResourceConfiguration = projectConfiguration.webArtifactConfigs.get(artifact.getName());
        if (artifactResourceConfiguration == null) {
            return null;
        }
        MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(artifactResourceConfiguration.moduleName);
        if (moduleResourceConfiguration == null) {
            LOG.debug("Maven resource configuration not found for module " + artifactResourceConfiguration.moduleName);
            return null;
        }
        ResourceRootConfiguration rootConfiguration = artifactResourceConfiguration.getRootConfiguration(root);
        if (rootConfiguration == null) {
            if (!FileUtil.isAncestor((File)new File(artifactResourceConfiguration.warSourceDirectory), (File)root, (boolean)false)) {
                return null;
            }
            return new MavenWebArtifactCopyingHandler(artifactResourceConfiguration, moduleResourceConfiguration);
        }
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfiguration, model.getProject(), moduleResourceConfiguration);
        return new MavenWebRootCopyingHandler(fileProcessor, artifactResourceConfiguration, rootConfiguration, moduleResourceConfiguration, root);
    }

    private static class MavenWebRootCopyingHandler
    extends MavenWebArtifactCopyingHandler {
        private final MavenResourceFileProcessor myFileProcessor;
        @NotNull
        private final ResourceRootConfiguration myRootConfiguration;
        private FileFilter myFileFilter;
        private boolean myMainWebAppRoot;

        private MavenWebRootCopyingHandler(@NotNull MavenResourceFileProcessor fileProcessor, @NotNull MavenWebArtifactConfiguration artifactConfiguration, @NotNull ResourceRootConfiguration rootConfiguration, @NotNull MavenModuleResourceConfiguration moduleResourceConfiguration, @NotNull File root) {
            if (fileProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (artifactConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactConfiguration", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (rootConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootConfiguration", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (moduleResourceConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleResourceConfiguration", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            super(artifactConfiguration, moduleResourceConfiguration);
            this.myFileProcessor = fileProcessor;
            this.myRootConfiguration = rootConfiguration;
            this.myFileFilter = new MavenResourceFileFilter(root, this.myRootConfiguration);
            this.myMainWebAppRoot = artifactConfiguration.warSourceDirectory.equals(StringUtil.trimEnd((String)rootConfiguration.directory, (String)"/"));
        }

        public void copyFile(@NotNull File from, @NotNull File to, @NotNull CompileContext context) throws IOException {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "copyFile"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "copyFile"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "copyFile"));
            }
            this.myFileProcessor.copyFile(from, to, this.myRootConfiguration, context, this.myMainWebAppRoot ? this.myFileFilter : FileUtilRt.ALL_FILES);
        }

        @Override
        protected int configurationHash() {
            return this.myRootConfiguration.computeConfigurationHash() + super.configurationHash() * 31;
        }

        @NotNull
        public FileFilter createFileFilter() {
            FileFilter superFilter = super.createFileFilter();
            FileFilter thisFilter = this.myMainWebAppRoot ? FileUtilRt.ALL_FILES : this.myFileFilter;
            FileFilter fileFilter = path -> superFilter.accept(path) && thisFilter.accept(path);
            if (fileFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "createFileFilter"));
            }
            return fileFilter;
        }
    }

    private static class MavenWebArtifactCopyingHandler
    extends FilterCopyHandler {
        private final ResourceRootConfiguration myWarRootConfig;
        private final MavenModuleResourceConfiguration myModuleResourceConfig;

        public MavenWebArtifactCopyingHandler(MavenWebArtifactConfiguration artifactConfig, MavenModuleResourceConfiguration moduleResourceConfig) {
            this(MavenWebArtifactCopyingHandler.getWarRootConfig(artifactConfig, moduleResourceConfig), moduleResourceConfig);
        }

        private MavenWebArtifactCopyingHandler(ResourceRootConfiguration warRootConfig, MavenModuleResourceConfiguration moduleResourceConfig) {
            super((FileFilter)new MavenResourceFileFilter(new File(FileUtil.toSystemDependentName((String)warRootConfig.directory)), warRootConfig));
            this.myWarRootConfig = warRootConfig;
            this.myModuleResourceConfig = moduleResourceConfig;
        }

        private static ResourceRootConfiguration getWarRootConfig(MavenWebArtifactConfiguration artifactConfig, MavenModuleResourceConfiguration moduleResourceConfig) {
            ResourceRootConfiguration rootConfig = new ResourceRootConfiguration();
            rootConfig.directory = artifactConfig.warSourceDirectory;
            rootConfig.targetPath = moduleResourceConfig.outputDirectory;
            rootConfig.includes.addAll(artifactConfig.packagingIncludes);
            rootConfig.excludes.addAll(artifactConfig.packagingExcludes);
            return rootConfig;
        }

        public void writeConfiguration(@NotNull PrintWriter out) {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebArtifactCopyingHandler", "writeConfiguration"));
            }
            out.print("maven hash:");
            out.println(this.configurationHash());
        }

        protected int configurationHash() {
            int hash = 0;
            hash = 31 * hash + this.myWarRootConfig.includes.hashCode();
            hash = 31 * hash + this.myWarRootConfig.excludes.hashCode();
            hash = 31 * hash + this.myWarRootConfig.computeConfigurationHash();
            hash = 31 * hash + this.myModuleResourceConfig.computeModuleConfigurationHash();
            return hash;
        }
    }
}

