/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.service.reporter.Report;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.build.ReportingAnalyzer;
import org.jetbrains.osgi.jps.build.ReportingBuilder;
import org.jetbrains.osgi.jps.build.ReportingProjectBuilder;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.jetbrains.osgi.jps.util.OrderedProperties;

public class BndWrapper {
    private final Reporter myReporter;

    public BndWrapper(Reporter reporter) {
        this.myReporter = reporter;
    }

    @NotNull
    public List<String> bundlifyLibraries(@NotNull Collection<File> dependencies, @NotNull File outputDir, @NotNull List<LibraryBundlificationRule> rules) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/osgi/jps/build/BndWrapper", "bundlifyLibraries"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/osgi/jps/build/BndWrapper", "bundlifyLibraries"));
        }
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "org/jetbrains/osgi/jps/build/BndWrapper", "bundlifyLibraries"));
        }
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)dependencies.size());
        for (File dependency : dependencies) {
            String path = dependency.getPath();
            if (CachingBundleInfoProvider.canBeBundlified(path)) {
                this.myReporter.progress(path);
                try {
                    File bundledDependency = this.wrap(dependency, outputDir, rules);
                    if (bundledDependency == null) continue;
                    result.add(bundledDependency.getPath());
                }
                catch (OsgiBuildException e) {
                    this.myReporter.warning(e.getMessage(), e.getCause(), e.getSourcePath(), -1);
                }
                continue;
            }
            if (!CachingBundleInfoProvider.isBundle(path)) continue;
            result.add(path);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/BndWrapper", "bundlifyLibraries"));
        }
        return arrayList;
    }

    @Nullable
    private File wrap(@NotNull File sourceFile, @NotNull File outputDir, @NotNull List<LibraryBundlificationRule> rules) throws OsgiBuildException {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/osgi/jps/build/BndWrapper", "wrap"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/osgi/jps/build/BndWrapper", "wrap"));
        }
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "org/jetbrains/osgi/jps/build/BndWrapper", "wrap"));
        }
        if (!sourceFile.isFile()) {
            throw new OsgiBuildException("The library '" + sourceFile + "' does not exist - please check module dependencies.");
        }
        File targetFile = new File(outputDir, sourceFile.getName());
        HashMap additionalProperties = ContainerUtil.newHashMap();
        long lastModified = Long.MIN_VALUE;
        for (LibraryBundlificationRule bundlificationRule : rules) {
            if (!bundlificationRule.appliesTo(sourceFile.getName())) continue;
            if (bundlificationRule.isDoNotBundle()) {
                return null;
            }
            additionalProperties.putAll(bundlificationRule.getAdditionalPropertiesMap());
            lastModified = Math.max(lastModified, bundlificationRule.getLastModified());
            if (!bundlificationRule.isStopAfterThisRule()) continue;
            break;
        }
        if (targetFile.exists() && targetFile.lastModified() >= sourceFile.lastModified() && targetFile.lastModified() >= lastModified) {
            return targetFile;
        }
        this.doWrap(sourceFile, targetFile, additionalProperties);
        return targetFile;
    }

    private void doWrap(@NotNull File inputJar, @NotNull File outputJar, @NotNull Map<String, String> properties) throws OsgiBuildException {
        if (inputJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputJar", "org/jetbrains/osgi/jps/build/BndWrapper", "doWrap"));
        }
        if (outputJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputJar", "org/jetbrains/osgi/jps/build/BndWrapper", "doWrap"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/osgi/jps/build/BndWrapper", "doWrap"));
        }
        if (!FileUtil.delete((File)outputJar)) {
            throw new OsgiBuildException("Can't delete outdated bundle '" + outputJar + "'");
        }
        if (!FileUtil.createParentDirs((File)outputJar)) {
            throw new OsgiBuildException("Can't create output directory for '" + outputJar + "'");
        }
        try (ReportingAnalyzer analyzer = new ReportingAnalyzer(this.myReporter);){
            analyzer.setPedantic(false);
            analyzer.setJar(inputJar);
            analyzer.putAll(properties, false);
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                Matcher m = p.matcher(inputJar.getName());
                if (!m.matches()) {
                    throw new OsgiBuildException("Can't calculate output bundle name for '" + inputJar + "' - rename file or use -properties");
                }
                analyzer.setProperty("Bundle-SymbolicName", m.group(1));
            }
            if (analyzer.getProperty("Export-Package") == null) {
                analyzer.setProperty("Export-Package", "*");
            }
            try (JarFile jarFile = new JarFile(inputJar);){
                analyzer.mergeManifest(jarFile.getManifest());
            }
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Analyzer.cleanupVersion((String)version);
                analyzer.setProperty("Bundle-Version", version);
            }
            analyzer.calcManifest();
            var8_12 = null;
            try (Jar jar = analyzer.getJar();){
                jar.write(outputJar);
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            analyzer.getWarnings().forEach(s -> this.reportProblem((String)s, null, false));
            analyzer.getErrors().forEach(s -> this.reportProblem((String)s, null, true));
        }
        catch (OsgiBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsgiBuildException("There was an unexpected problem when trying to bundlify", e, null);
        }
    }

    public void build(@NotNull Map<String, String> properties, @NotNull File[] classPath, @NotNull File[] srcPath, @NotNull File outputFile) throws Exception {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        try (ReportingBuilder builder = new ReportingBuilder(this.myReporter);){
            builder.setProperties(OrderedProperties.fromMap(properties));
            builder.setPedantic(false);
            builder.setClasspath(classPath);
            builder.setSourcepath(srcPath);
            this.doBuild(builder, outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(@NotNull File bndFile, @NotNull File[] classPath, @NotNull File[] srcPath, @NotNull File outputFile) throws Exception {
        block69: {
            if (bndFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bndFile", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
            }
            if (classPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
            }
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
            }
            if (outputFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
            }
            Workspace workspace = Workspace.findWorkspace((File)bndFile);
            if (workspace != null) {
                try (Project project = new Project(workspace, null, bndFile);
                     ProjectBuilder projectBuilder = project.getBuilder(null);){
                    for (Builder sub : projectBuilder.getSubBuilders()) {
                        File source = sub == projectBuilder ? bndFile : sub.getPropertiesFile();
                        String prevSource = this.myReporter.setReportSource(source.getPath());
                        try {
                            ReportingProjectBuilder builder = new ReportingProjectBuilder(this.myReporter, (ProjectBuilder)sub);
                            Throwable throwable = null;
                            try {
                                builder.setProperties(source);
                                File output = sub == projectBuilder ? outputFile : new File(outputFile.getParent(), sub.getBsn() + ".jar");
                                this.doBuild((Builder)builder, output);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (builder == null) continue;
                                if (throwable != null) {
                                    try {
                                        builder.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                builder.close();
                            }
                        }
                        finally {
                            this.myReporter.setReportSource(prevSource);
                        }
                    }
                    break block69;
                }
            }
            try (Builder mainBuilder = new Builder();){
                mainBuilder.setProperties(bndFile);
                mainBuilder.setPedantic(false);
                for (Builder sub : mainBuilder.getSubBuilders()) {
                    File source = sub == mainBuilder ? bndFile : sub.getPropertiesFile();
                    String prevSource = this.myReporter.setReportSource(source.getPath());
                    try {
                        ReportingBuilder builder = new ReportingBuilder(this.myReporter, sub);
                        Throwable throwable = null;
                        try {
                            builder.setProperties(source);
                            builder.setPedantic(false);
                            builder.setClasspath(classPath);
                            builder.setSourcepath(srcPath);
                            File output = sub == mainBuilder ? outputFile : new File(outputFile.getParent(), sub.getBsn() + ".jar");
                            this.doBuild(builder, output);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (builder == null) continue;
                            if (throwable != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            builder.close();
                        }
                    }
                    finally {
                        this.myReporter.setReportSource(prevSource);
                    }
                }
            }
        }
    }

    private void doBuild(@NotNull Builder builder, @NotNull File outputFile) throws Exception {
        File manifestFile;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/osgi/jps/build/BndWrapper", "doBuild"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/osgi/jps/build/BndWrapper", "doBuild"));
        }
        String manifest = builder.getProperty("-manifest");
        if (manifest != null && (manifestFile = builder.getFile(manifest)) != null) {
            try (FileInputStream stream = new FileInputStream(manifestFile);){
                Properties p = new Properties();
                p.load(stream);
                String value = p.getProperty(Attributes.Name.MANIFEST_VERSION.toString());
                if (StringUtil.isEmptyOrSpaces((String)value)) {
                    String message = "Manifest misses a Manifest-Version entry. This may produce an empty manifest in the resulting bundle.";
                    this.myReporter.warning(message, null, manifest, -1);
                }
            }
            catch (Exception e) {
                this.myReporter.warning("Can't read manifest: " + e.getMessage(), e, manifest, -1);
            }
        }
        try (Jar jar = builder.build();){
            jar.setName(outputFile.getName());
            jar.write(outputFile);
        }
        builder.getWarnings().forEach(s -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/osgi/jps/build/BndWrapper", "lambda$doBuild$2"));
            }
            this.reportProblem((String)s, builder.getLocation(s), false);
        });
        builder.getErrors().forEach(s -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/osgi/jps/build/BndWrapper", "lambda$doBuild$3"));
            }
            this.reportProblem((String)s, builder.getLocation(s), true);
        });
    }

    private void reportProblem(String message, Report.Location location, boolean error) {
        String sourcePath = null;
        int lineNum = -1;
        if (location != null) {
            sourcePath = location.file;
            if (location.line > 0) {
                lineNum = location.line + 1;
            }
        }
        if (error) {
            this.myReporter.error(message, null, sourcePath, lineNum);
        } else {
            this.myReporter.warning(message, null, sourcePath, lineNum);
        }
    }

    @NotNull
    public static File getOutputDir(@NotNull File moduleOutputDir) throws OsgiBuildException {
        if (moduleOutputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOutputDir", "org/jetbrains/osgi/jps/build/BndWrapper", "getOutputDir"));
        }
        File outputDir = new File(moduleOutputDir.getParent(), "bundles");
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new OsgiBuildException("Can't create output directory '" + outputDir + "'. Please check file permissions.");
        }
        File file = outputDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/BndWrapper", "getOutputDir"));
        }
        return file;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<String> getBundleNames(@NotNull File bndFile) {
        block25: {
            Throwable throwable;
            Builder builder;
            block22: {
                List<String> list;
                block23: {
                    block24: {
                        if (bndFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bndFile", "org/jetbrains/osgi/jps/build/BndWrapper", "getBundleNames"));
                        }
                        builder = new Builder();
                        throwable = null;
                        builder.setProperties(bndFile);
                        builder.setPedantic(false);
                        List subs = builder.getSubBuilders();
                        if (subs.size() <= 0 || subs.get(0) == builder) break block22;
                        list = subs.stream().map(sub -> sub.getBsn() + ".jar").collect(Collectors.toList());
                        if (builder == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    builder.close();
                }
                List<String> list2 = list;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/BndWrapper", "getBundleNames"));
                }
                return list2;
            }
            try {
                if (builder != null) {
                    if (throwable != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        builder.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (builder != null) {
                                if (throwable != null) {
                                    try {
                                        builder.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    builder.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.getInstance(BndWrapper.class).warn((Throwable)e);
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/BndWrapper", "getBundleNames"));
        }
        return list;
    }
}

