/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsExcludePatternImpl;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.impl.JpsDependenciesListImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;

public class JpsModuleImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsModuleImpl<P>>
implements JpsTypedModule<P> {
    private static final JpsUrlListRole CONTENT_ROOTS_ROLE = new JpsUrlListRole("content roots");
    private static final JpsUrlListRole EXCLUDED_ROOTS_ROLE = new JpsUrlListRole("excluded roots");
    private static final JpsElementChildRole<JpsDependenciesListImpl> DEPENDENCIES_LIST_CHILD_ROLE = JpsElementChildRoleBase.create("dependencies");
    private static final JpsElementCollectionRole<JpsExcludePattern> EXCLUDE_PATTERNS_ROLE = JpsElementCollectionRole.create(JpsElementChildRoleBase.create("exclude patterns"));
    private final JpsModuleType<P> myModuleType;
    private final JpsLibraryCollection myLibraryCollection;

    public JpsModuleImpl(JpsModuleType<P> type, @NotNull String name, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "<init>"));
        }
        super(name);
        this.myModuleType = type;
        this.myContainer.setChild(this.myModuleType.getPropertiesRole(), properties);
        this.myContainer.setChild(CONTENT_ROOTS_ROLE);
        this.myContainer.setChild(EXCLUDED_ROOTS_ROLE);
        this.myContainer.setChild(DEPENDENCIES_LIST_CHILD_ROLE, new JpsDependenciesListImpl());
        this.getDependenciesList().addModuleSourceDependency();
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE));
        this.myContainer.setChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        this.myContainer.setChild(JpsSdkReferencesTableImpl.ROLE);
    }

    private JpsModuleImpl(JpsModuleImpl<P> original) {
        super(original);
        this.myModuleType = original.myModuleType;
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @Override
    @NotNull
    public JpsModuleImpl<P> createCopy() {
        JpsModuleImpl<P> jpsModuleImpl = new JpsModuleImpl<P>(this);
        if (jpsModuleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "createCopy"));
        }
        return jpsModuleImpl;
    }

    @Override
    public JpsElementType<P> getType() {
        return this.myModuleType;
    }

    @Override
    @NotNull
    public P getProperties() {
        Object p = this.myContainer.getChild(this.myModuleType.getPropertiesRole());
        if (p == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getProperties"));
        }
        return p;
    }

    @Override
    public <P extends JpsElement> JpsTypedModule<P> asTyped(@NotNull JpsModuleType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "asTyped"));
        }
        return this.myModuleType.equals(type) ? this : null;
    }

    @Override
    @NotNull
    public JpsUrlList getContentRootsList() {
        JpsUrlList jpsUrlList = this.myContainer.getChild(CONTENT_ROOTS_ROLE);
        if (jpsUrlList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getContentRootsList"));
        }
        return jpsUrlList;
    }

    @Override
    @NotNull
    public JpsUrlList getExcludeRootsList() {
        JpsUrlList jpsUrlList = this.myContainer.getChild(EXCLUDED_ROOTS_ROLE);
        if (jpsUrlList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getExcludeRootsList"));
        }
        return jpsUrlList;
    }

    @Override
    @NotNull
    public List<JpsModuleSourceRoot> getSourceRoots() {
        List<JpsModuleSourceRoot> list = ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE))).getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSourceRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModuleSourceRoot<P>> getSourceRoots(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSourceRoots"));
        }
        Iterable<JpsTypedModuleSourceRoot<P>> iterable = ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE))).getElementsOfType(type);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSourceRoots"));
        }
        return iterable;
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = this.addSourceRoot(url, rootType, (JpsElement)rootType.createDefaultProperties());
        if (jpsModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        return jpsModuleSourceRoot;
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        JpsModuleSourceRootImpl<P> root = new JpsModuleSourceRootImpl<P>(url, rootType, properties);
        this.addSourceRoot(root);
        JpsModuleSourceRootImpl<P> jpsModuleSourceRootImpl = root;
        if (jpsModuleSourceRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        return jpsModuleSourceRootImpl;
    }

    @Override
    public void addSourceRoot(@NotNull JpsModuleSourceRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addSourceRoot"));
        }
        ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE))).addChild(root);
    }

    @Override
    public void removeSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "removeSourceRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "removeSourceRoot"));
        }
        JpsElementCollection roots = (JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE));
        for (JpsModuleSourceRoot root : roots.getElements()) {
            if (!root.getRootType().equals(rootType) || !root.getUrl().equals(url)) continue;
            roots.removeChild(root);
            break;
        }
    }

    @Override
    public void addExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        if (baseDirUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirUrl", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addExcludePattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addExcludePattern"));
        }
        ((JpsElementCollection)this.myContainer.getOrSetChild(EXCLUDE_PATTERNS_ROLE)).addChild(new JpsExcludePatternImpl(baseDirUrl, pattern));
    }

    @Override
    public void removeExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        if (baseDirUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirUrl", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "removeExcludePattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "removeExcludePattern"));
        }
        JpsElementCollection child = (JpsElementCollection)((Object)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE));
        if (child != null) {
            for (JpsExcludePattern excludePattern : child.getElements()) {
                if (!excludePattern.getBaseDirUrl().equals(baseDirUrl) || !excludePattern.getPattern().equals(pattern)) continue;
                child.removeChild(excludePattern);
            }
        }
    }

    @Override
    public List<JpsExcludePattern> getExcludePatterns() {
        JpsElementCollection child = (JpsElementCollection)((Object)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE));
        return child != null ? child.getElements() : Collections.emptyList();
    }

    @Override
    @NotNull
    public JpsDependenciesList getDependenciesList() {
        JpsDependenciesList jpsDependenciesList = this.myContainer.getChild(DEPENDENCIES_LIST_CHILD_ROLE);
        if (jpsDependenciesList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getDependenciesList"));
        }
        return jpsDependenciesList;
    }

    @Override
    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        JpsSdkReferencesTable jpsSdkReferencesTable = this.myContainer.getChild(JpsSdkReferencesTableImpl.ROLE);
        if (jpsSdkReferencesTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSdkReferencesTable"));
        }
        return jpsSdkReferencesTable;
    }

    @Override
    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(@NotNull JpsSdkType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSdkReference"));
        }
        JpsSdkReference<P> sdkReference = this.getSdkReferencesTable().getSdkReference(type);
        if (sdkReference != null) {
            return sdkReference;
        }
        JpsProject project = this.getProject();
        if (project != null) {
            return project.getSdkReferencesTable().getSdkReference(type);
        }
        return null;
    }

    @Override
    public <P extends JpsElement> JpsSdk<P> getSdk(@NotNull JpsSdkType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getSdk"));
        }
        JpsSdkReference<P> reference = this.getSdkReference(type);
        if (reference == null) {
            return null;
        }
        JpsTypedLibrary library = (JpsTypedLibrary)reference.resolve();
        return library != null ? (JpsSdk)library.getProperties() : null;
    }

    @Override
    public void delete() {
        ((JpsElementCollection)((Object)this.myParent)).removeChild(this);
    }

    @Override
    @NotNull
    public JpsModuleReference createReference() {
        JpsModuleReferenceImpl jpsModuleReferenceImpl = new JpsModuleReferenceImpl(this.getName());
        if (jpsModuleReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "createReference"));
        }
        return jpsModuleReferenceImpl;
    }

    @Override
    @NotNull
    public <P extends JpsElement, Type extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addModuleLibrary(@NotNull String name, @NotNull Type type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        JpsLibrary jpsLibrary = this.myLibraryCollection.addLibrary(name, type);
        if (jpsLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        return jpsLibrary;
    }

    @Override
    public void addModuleLibrary(@NotNull JpsLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "addModuleLibrary"));
        }
        this.myLibraryCollection.addLibrary(library);
    }

    @Override
    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        JpsLibraryCollection jpsLibraryCollection = this.myLibraryCollection;
        if (jpsLibraryCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getLibraryCollection"));
        }
        return jpsLibraryCollection;
    }

    @Override
    @Nullable
    public JpsProject getProject() {
        JpsModel model = this.getModel();
        return model != null ? model.getProject() : null;
    }

    @Override
    @NotNull
    public JpsModuleType<P> getModuleType() {
        JpsModuleType<P> jpsModuleType = this.myModuleType;
        if (jpsModuleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleImpl", "getModuleType"));
        }
        return jpsModuleType;
    }
}

