/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.resources;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.model.module.JpsModule;

public class ResourcesBuilder
extends TargetBuilder<ResourceRootDescriptor, ResourcesTarget> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.resources.ResourcesBuilder");
    public static final String BUILDER_NAME = "Resource Compiler";
    private static final List<StandardResourceBuilderEnabler> ourEnablers = Collections.synchronizedList(new ArrayList());

    public ResourcesBuilder() {
        super(ResourcesTargetType.ALL_TYPES);
    }

    public static void registerEnabler(StandardResourceBuilderEnabler enabler) {
        ourEnablers.add(enabler);
    }

    @Override
    public void build(@NotNull ResourcesTarget target, @NotNull DirtyFilesHolder<ResourceRootDescriptor, ResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "build"));
        }
        if (!ResourcesBuilder.isResourceProcessingEnabled(target.getModule())) {
            return;
        }
        try {
            HashMap skippedRoots = new HashMap();
            holder.processDirtyFiles((target_, file, sourceRoot) -> {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "lambda$build$0"));
                }
                if (outputConsumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "lambda$build$0"));
                }
                Boolean isSkipped = (Boolean)skippedRoots.get(sourceRoot);
                if (isSkipped == null) {
                    File outputDir = target_.getOutputDir();
                    isSkipped = outputDir == null || FileUtil.filesEqual((File)outputDir, (File)sourceRoot.getRootFile());
                    skippedRoots.put(sourceRoot, isSkipped);
                }
                if (isSkipped.booleanValue()) {
                    return true;
                }
                try {
                    ResourcesBuilder.copyResource(context, sourceRoot, file, outputConsumer);
                    return !context.getCancelStatus().isCanceled();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    String sourcePath = FileUtil.toSystemIndependentName((String)file.getPath());
                    context.processMessage(new CompilerMessage("resources", BuildMessage.Kind.ERROR, e.getMessage(), sourcePath));
                    return false;
                }
            });
            context.checkCanceled();
            context.processMessage(new ProgressMessage(""));
        }
        catch (BuildDataCorruptedException | ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProjectBuildException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isResourceProcessingEnabled(JpsModule module) {
        List<StandardResourceBuilderEnabler> list = ourEnablers;
        synchronized (list) {
            for (StandardResourceBuilderEnabler enabler : ourEnablers) {
                if (enabler.isResourceProcessingEnabled(module)) continue;
                return false;
            }
        }
        return true;
    }

    private static void copyResource(CompileContext context, ResourceRootDescriptor rd, File file, BuildOutputConsumer outputConsumer) throws IOException {
        File outputRoot = rd.getTarget().getOutputDir();
        if (outputRoot == null) {
            return;
        }
        String sourceRootPath = FileUtil.toSystemIndependentName((String)rd.getRootFile().getAbsolutePath());
        String relativePath = FileUtil.getRelativePath((String)sourceRootPath, (String)FileUtil.toSystemIndependentName((String)file.getPath()), (char)'/');
        String prefix = rd.getPackagePrefix();
        StringBuilder targetPath = new StringBuilder();
        targetPath.append(FileUtil.toSystemIndependentName((String)outputRoot.getPath()));
        if (prefix.length() > 0) {
            targetPath.append('/').append(prefix.replace('.', '/'));
        }
        targetPath.append('/').append(relativePath);
        context.processMessage(new ProgressMessage("Copying resources... [" + rd.getTarget().getModule().getName() + "]"));
        String outputPath = targetPath.toString();
        File targetFile = new File(outputPath);
        FileUtil.copyContent((File)file, (File)targetFile);
        try {
            outputConsumer.registerOutputFile(targetFile, Collections.singletonList(file.getPath()));
        }
        catch (Exception e) {
            context.processMessage(new CompilerMessage(BUILDER_NAME, e));
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/resources/ResourcesBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }
}

