/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class BuildingTargetProgressMessage
extends BuildMessage {
    private final Collection<? extends BuildTarget<?>> myTargets;
    @NotNull
    private final Event myEventType;

    public BuildingTargetProgressMessage(@NotNull Collection<? extends BuildTarget<?>> targets, @NotNull Event event) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "org/jetbrains/jps/incremental/messages/BuildingTargetProgressMessage", "<init>"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/jps/incremental/messages/BuildingTargetProgressMessage", "<init>"));
        }
        super(BuildingTargetProgressMessage.composeMessageText(targets, event), BuildMessage.Kind.PROGRESS);
        this.myTargets = targets;
        this.myEventType = event;
    }

    private static String composeMessageText(Collection<? extends BuildTarget<?>> targets, Event event) {
        String targetsString = StringUtil.join(targets, (Function)((NotNullFunction)dom -> dom.getPresentableName()), (String)", ");
        return (event == Event.STARTED ? "Started" : "Finished") + " building " + targetsString;
    }

    @NotNull
    public Collection<? extends BuildTarget<?>> getTargets() {
        Collection<? extends BuildTarget<?>> collection = this.myTargets;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/messages/BuildingTargetProgressMessage", "getTargets"));
        }
        return collection;
    }

    @NotNull
    public Event getEventType() {
        Event event = this.myEventType;
        if (event == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/messages/BuildingTargetProgressMessage", "getEventType"));
        }
        return event;
    }

    public static enum Event {
        STARTED,
        FINISHED;

    }
}

