/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.jps.backwardRefs.BackwardReferenceIndexWriter;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;

public class BackwardReferenceIndexUtil {
    static void registerFile(String filePath, TObjectIntHashMap<? extends JavacRef> refs, List<JavacDef> defs, BackwardReferenceIndexWriter writer) {
        try {
            int fileId = writer.enumeratePath(filePath);
            int funExprId = 0;
            HashMap<LightRef, Void> definitions = new HashMap<LightRef, Void>(defs.size());
            HashMap<LightRef, Collection<LightRef>> backwardHierarchyMap = new HashMap<LightRef, Collection<LightRef>>();
            THashMap signatureData = new THashMap();
            AnonymousClassEnumerator anonymousClassEnumerator = new AnonymousClassEnumerator();
            for (JavacDef def : defs) {
                if (def instanceof JavacDef.JavacClassDef) {
                    JavacRef[] superClasses;
                    LightRef.LightClassHierarchyElementDef aClass;
                    JavacRef.JavacClass sym = (JavacRef.JavacClass)def.getDefinedElement();
                    if (sym.isAnonymous()) {
                        JavacRef[] classes = ((JavacDef.JavacClassDef)def).getSuperClasses();
                        aClass = anonymousClassEnumerator.addAnonymous(sym.getName(), writer.asClassUsage(classes[0]));
                    } else {
                        aClass = writer.asClassUsage((JavacRef)sym);
                    }
                    definitions.put(aClass, null);
                    for (JavacRef superClass : superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses()) {
                        LightRef.JavaLightClassRef superClassRef = writer.asClassUsage(superClass);
                        backwardHierarchyMap.computeIfAbsent(superClassRef, k -> new SmartList()).add(aClass);
                    }
                    continue;
                }
                if (def instanceof JavacDef.JavacFunExprDef) {
                    LightRef.JavaLightClassRef functionalType = writer.asClassUsage(def.getDefinedElement());
                    int id = funExprId++;
                    LightRef.JavaLightFunExprDef result = new LightRef.JavaLightFunExprDef(id);
                    definitions.put(result, null);
                    ((Collection)ContainerUtil.getOrCreate(backwardHierarchyMap, (Object)functionalType, () -> new SmartList())).add(result);
                    continue;
                }
                if (!(def instanceof JavacDef.JavacMemberDef)) continue;
                LightRef ref = writer.enumerateNames(def.getDefinedElement(), (Function<String, Integer>)((Function)name -> anonymousClassEnumerator.getLightRefIfAnonymous(name)));
                LightRef.JavaLightClassRef returnType = writer.asClassUsage(((JavacDef.JavacMemberDef)def).getReturnType());
                if (ref == null || returnType == null) continue;
                SignatureData data = new SignatureData(returnType.getName(), ((JavacDef.JavacMemberDef)def).getIteratorKind(), ((JavacDef.JavacMemberDef)def).isStatic());
                signatureData.computeIfAbsent(data, element -> new SmartList()).add(ref);
            }
            THashMap convertedRefs = new THashMap();
            IOException[] exception = new IOException[]{null};
            refs.forEachEntry((arg_0, arg_1) -> BackwardReferenceIndexUtil.lambda$registerFile$5(writer, anonymousClassEnumerator, (Map)convertedRefs, exception, arg_0, arg_1));
            if (exception[0] != null) {
                throw exception[0];
            }
            writer.writeData(fileId, new CompiledFileData(backwardHierarchyMap, (Map<LightRef, Integer>)convertedRefs, definitions, (Map<SignatureData, Collection<LightRef>>)signatureData));
        }
        catch (IOException e) {
            writer.setRebuildCause(e);
        }
    }

    private static /* synthetic */ boolean lambda$registerFile$5(BackwardReferenceIndexWriter writer, AnonymousClassEnumerator anonymousClassEnumerator, Map convertedRefs, IOException[] exception, JavacRef ref, int count) {
        try {
            LightRef lightRef = writer.enumerateNames(ref, (Function<String, Integer>)((Function)name -> anonymousClassEnumerator.getLightRefIfAnonymous(name)));
            if (lightRef != null) {
                Integer old = (Integer)convertedRefs.get(lightRef);
                convertedRefs.put(lightRef, old == null ? count : old + count);
            }
        }
        catch (IOException e) {
            exception[0] = e;
            return false;
        }
        return true;
    }

    private static class AnonymousClassEnumerator {
        private THashMap<String, LightRef.LightClassHierarchyElementDef> myAnonymousName2Id = null;

        private AnonymousClassEnumerator() {
        }

        private LightRef.JavaLightAnonymousClassRef addAnonymous(String internalName, LightRef.JavaLightClassRef base) {
            if (this.myAnonymousName2Id == null) {
                this.myAnonymousName2Id = new THashMap();
            }
            int anonymousIdx = this.myAnonymousName2Id.size();
            this.myAnonymousName2Id.put((Object)internalName, (Object)base);
            return new LightRef.JavaLightAnonymousClassRef(anonymousIdx);
        }

        private Integer getLightRefIfAnonymous(String className) {
            if (this.myAnonymousName2Id == null) {
                return null;
            }
            LightRef.LightClassHierarchyElementDef ref = (LightRef.LightClassHierarchyElementDef)this.myAnonymousName2Id.get((Object)className);
            return ref == null ? null : Integer.valueOf(ref.getName());
        }
    }
}

