/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtensionFileNameMatcher
extends FileNameMatcherEx {
    private final String myExtension;
    private final String myDotExtension;

    public ExtensionFileNameMatcher(@NotNull @NonNls String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileTypes/ExtensionFileNameMatcher", "<init>"));
        }
        this.myExtension = extension.toLowerCase();
        this.myDotExtension = "." + this.myExtension;
    }

    @Override
    public boolean acceptsCharSequence(@NonNls @NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ExtensionFileNameMatcher", "acceptsCharSequence"));
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.myDotExtension);
    }

    @Override
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = "*." + this.myExtension;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/ExtensionFileNameMatcher", "getPresentableString"));
        }
        return string;
    }

    public String getExtension() {
        return this.myExtension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionFileNameMatcher that = (ExtensionFileNameMatcher)o;
        return this.myExtension.equals(that.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }

    public String toString() {
        return this.getPresentableString();
    }
}

