/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JarListSanitizer {
    private static final byte[] sBuffer = new byte[4096];
    private static final String CACHE_FILENAME = "jarlist.cache";
    private static final Pattern READ_PATTERN = Pattern.compile("^(\\d+) (\\d+) ([0-9a-f]+) (.+)$");
    private final File mOut;
    private final PrintStream mOutStream;

    public JarListSanitizer(File out) {
        this.mOut = out;
        this.mOutStream = System.out;
    }

    public JarListSanitizer(File out, PrintStream outStream) {
        this.mOut = out;
        this.mOutStream = outStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> sanitize(Collection<File> files) throws DifferentLibException, Sha1Exception {
        ArrayList<File> results = new ArrayList<File>();
        Map<String, JarEntity> jarList = this.getCachedJarList();
        boolean updateJarList = false;
        for (JarEntity entity : jarList.values()) {
            if (entity.getFile().exists()) continue;
            results.add(entity.getFile());
        }
        if (!results.isEmpty()) {
            for (File f : results) {
                jarList.remove(f.getAbsolutePath());
            }
            results.clear();
            updateJarList = true;
        }
        HashMap<String, List<JarEntity>> nameMap = new HashMap<String, List<JarEntity>>();
        for (File file : files) {
            String path = file.getAbsolutePath();
            JarEntity entity = jarList.get(path);
            if (entity == null) {
                entity = new JarEntity(file);
                jarList.put(path, entity);
                updateJarList = true;
            } else {
                updateJarList |= entity.checkValidity();
            }
            String filename = file.getName();
            ArrayList<JarEntity> nameList = (ArrayList<JarEntity>)nameMap.get(filename);
            if (nameList == null) {
                nameList = new ArrayList<JarEntity>();
                nameMap.put(filename, nameList);
            }
            nameList.add(entity);
        }
        try {
            for (Map.Entry entry : nameMap.entrySet()) {
                List list = (List)entry.getValue();
                this.checkEntities((String)entry.getKey(), list);
                results.add(((JarEntity)list.get(0)).getFile());
            }
            this.checkSupportLibs(nameMap, results);
        }
        finally {
            if (updateJarList) {
                this.writeJarList(nameMap);
            }
        }
        return results;
    }

    private void checkEntities(String filename, List<JarEntity> list) throws DifferentLibException, Sha1Exception {
        if (list.size() == 1) {
            return;
        }
        JarEntity baseEntity = list.get(0);
        long baseLength = baseEntity.getLength();
        String baseSha1 = baseEntity.getSha1();
        int count = list.size();
        for (int i = 1; i < count; ++i) {
            JarEntity entity = list.get(i);
            if (entity.getLength() == baseLength && entity.getSha1().equals(baseSha1)) continue;
            throw new DifferentLibException("Jar mismatch! Fix your dependencies", this.getEntityDetails(filename, list));
        }
    }

    private void checkSupportLibs(Map<String, List<JarEntity>> nameMap, List<File> results) {
        List<JarEntity> v4 = nameMap.get("android-support-v4.jar");
        List<JarEntity> v13 = nameMap.get("android-support-v13.jar");
        if (v13 != null && v4 != null) {
            this.mOutStream.println("WARNING: Found both android-support-v4 and android-support-v13 in the dependency list.");
            this.mOutStream.println("Because v13 includes v4, using only v13.");
            results.remove(v4.get(0).getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JarEntity> getCachedJarList() {
        HashMap<String, JarEntity> cache = new HashMap<String, JarEntity>();
        File cacheFile = new File(this.mOut, CACHE_FILENAME);
        if (!cacheFile.exists()) {
            return cache;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cacheFile), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (line.charAt(0) == '#' || !(m = READ_PATTERN.matcher(line)).matches()) continue;
                String path = m.group(4);
                JarEntity entity = new JarEntity(path, Long.parseLong(m.group(1)), Long.parseLong(m.group(2)), m.group(3));
                cache.put(path, entity);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarList(Map<String, List<JarEntity>> nameMap) {
        File cacheFile = new File(this.mOut, CACHE_FILENAME);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "UTF-8");
            writer.write("# cache for current jar dependency. DO NOT EDIT.\n");
            writer.write("# format is <lastModified> <length> <SHA-1> <path>\n");
            writer.write("# Encoding is UTF-8\n");
            for (List<JarEntity> list : nameMap.values()) {
                int i = 0;
                while (i < list.size()) {
                    JarEntity entity = list.get(i);
                    if (entity.hasSha1()) {
                        ++i;
                        continue;
                    }
                    list.remove(i);
                }
                if (list.size() <= 1) continue;
                for (JarEntity entity : list) {
                    writer.write(String.format("%d %d %s %s\n", entity.getLastModified(), entity.getLength(), entity.getSha1(), entity.getFile().getAbsolutePath()));
                }
            }
        }
        catch (IOException e) {
            this.mOutStream.println("WARNING: unable to write jarlist cache file " + cacheFile.getAbsolutePath());
        }
        catch (Sha1Exception sha1Exception) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String[] getEntityDetails(String filename, List<JarEntity> list) throws Sha1Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("Found %d versions of %s in the dependency list,", list.size(), filename));
        result.add("but not all the versions are identical (check is based on SHA-1 only at this time).");
        result.add("All versions of the libraries must be the same at this time.");
        result.add("Versions found are:");
        for (JarEntity entity : list) {
            result.add("Path: " + entity.getFile().getAbsolutePath());
            result.add("\tLength: " + entity.getLength());
            result.add("\tSHA-1: " + entity.getSha1());
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSha1(File f) throws Sha1Exception {
        byte[] byArray = sBuffer;
        synchronized (sBuffer) {
            String string;
            FileInputStream fis = null;
            try {
                int length;
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                fis = new FileInputStream(f);
                while ((length = fis.read(sBuffer)) > 0) {
                    md.update(sBuffer, 0, length);
                }
                string = JarListSanitizer.byteArray2Hex(md.digest());
            }
            catch (Exception e) {
                throw new Sha1Exception(f, (Throwable)e);
            }
            return string;
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String byteArray2Hex(byte[] hash) {
        try (Formatter formatter = new Formatter();){
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static final class Sha1Exception
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final File mJarFile;

        public Sha1Exception(File jarFile, Throwable cause) {
            super(cause);
            this.mJarFile = jarFile;
        }

        public File getJarFile() {
            return this.mJarFile;
        }
    }

    public static final class DifferentLibException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String[] mDetails;

        public DifferentLibException(String message, String[] details) {
            super(message);
            this.mDetails = details;
        }

        public String[] getDetails() {
            return this.mDetails;
        }
    }

    private static final class JarEntity {
        private final File mFile;
        private final long mLastModified;
        private long mLength;
        private String mSha1;

        private JarEntity(String path, long lastModified, long length, String sha1) {
            this.mFile = new File(path);
            this.mLastModified = lastModified;
            this.mLength = length;
            this.mSha1 = sha1;
        }

        private JarEntity(File file) {
            this.mFile = file;
            this.mLastModified = file.lastModified();
            this.mLength = file.length();
        }

        private boolean checkValidity() {
            if (this.mLastModified != this.mFile.lastModified()) {
                this.mLength = this.mFile.length();
                this.mSha1 = null;
                return true;
            }
            return false;
        }

        private File getFile() {
            return this.mFile;
        }

        private long getLastModified() {
            return this.mLastModified;
        }

        private long getLength() {
            return this.mLength;
        }

        private String getSha1() throws Sha1Exception {
            if (this.mSha1 == null) {
                this.mSha1 = JarListSanitizer.getSha1(this.mFile);
            }
            return this.mSha1;
        }

        private boolean hasSha1() {
            return this.mSha1 != null;
        }
    }
}

